/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkMemoryAllocateFlagsInfo;

public class VkMemoryAllocateFlagsInfoKHR
extends VkMemoryAllocateFlagsInfo {
    protected VkMemoryAllocateFlagsInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkMemoryAllocateFlagsInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkMemoryAllocateFlagsInfoKHR(address, container);
    }

    public VkMemoryAllocateFlagsInfoKHR(ByteBuffer container) {
        super(container);
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR sType$Default() {
        return this.sType(1000060000);
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
        VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR deviceMask(@NativeType(value="uint32_t") int value) {
        VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
        return this;
    }

    @Override
    public VkMemoryAllocateFlagsInfoKHR set(int sType, long pNext, int flags, int deviceMask) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.deviceMask(deviceMask);
        return this;
    }

    public VkMemoryAllocateFlagsInfoKHR set(VkMemoryAllocateFlagsInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkMemoryAllocateFlagsInfoKHR malloc() {
        return new VkMemoryAllocateFlagsInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfoKHR calloc() {
        return new VkMemoryAllocateFlagsInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkMemoryAllocateFlagsInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkMemoryAllocateFlagsInfoKHR create(long address) {
        return new VkMemoryAllocateFlagsInfoKHR(address, null);
    }

    @Nullable
    public static VkMemoryAllocateFlagsInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkMemoryAllocateFlagsInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkMemoryAllocateFlagsInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkMemoryAllocateFlagsInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR mallocStack() {
        return VkMemoryAllocateFlagsInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR callocStack() {
        return VkMemoryAllocateFlagsInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR mallocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkMemoryAllocateFlagsInfoKHR callocStack(MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkMemoryAllocateFlagsInfoKHR.calloc(capacity, stack);
    }

    public static VkMemoryAllocateFlagsInfoKHR malloc(MemoryStack stack) {
        return new VkMemoryAllocateFlagsInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkMemoryAllocateFlagsInfoKHR calloc(MemoryStack stack) {
        return new VkMemoryAllocateFlagsInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static class Buffer
    extends VkMemoryAllocateFlagsInfo.Buffer {
        private static final VkMemoryAllocateFlagsInfoKHR ELEMENT_FACTORY = VkMemoryAllocateFlagsInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkMemoryAllocateFlagsInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @Override
        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkMemoryAllocateFlagsInfoKHR.nsType(this.address(), value);
            return this;
        }

        @Override
        public Buffer sType$Default() {
            return this.sType(1000060000);
        }

        @Override
        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkMemoryAllocateFlagsInfoKHR.npNext(this.address(), value);
            return this;
        }

        @Override
        public Buffer flags(@NativeType(value="VkMemoryAllocateFlags") int value) {
            VkMemoryAllocateFlagsInfoKHR.nflags(this.address(), value);
            return this;
        }

        @Override
        public Buffer deviceMask(@NativeType(value="uint32_t") int value) {
            VkMemoryAllocateFlagsInfoKHR.ndeviceMask(this.address(), value);
            return this;
        }
    }
}

