/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkImportMemoryHostPointerInfoEXT
extends Struct<VkImportMemoryHostPointerInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int HANDLETYPE;
    public static final int PHOSTPOINTER;

    protected VkImportMemoryHostPointerInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkImportMemoryHostPointerInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkImportMemoryHostPointerInfoEXT(address, container);
    }

    public VkImportMemoryHostPointerInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkImportMemoryHostPointerInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkImportMemoryHostPointerInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkImportMemoryHostPointerInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
    public int handleType() {
        return VkImportMemoryHostPointerInfoEXT.nhandleType(this.address());
    }

    @NativeType(value="void *")
    public long pHostPointer() {
        return VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address());
    }

    public VkImportMemoryHostPointerInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkImportMemoryHostPointerInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT sType$Default() {
        return this.sType(1000178000);
    }

    public VkImportMemoryHostPointerInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkImportMemoryHostPointerInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
        VkImportMemoryHostPointerInfoEXT.nhandleType(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT pHostPointer(@NativeType(value="void *") long value) {
        VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address(), value);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT set(int sType, long pNext, int handleType, long pHostPointer) {
        this.sType(sType);
        this.pNext(pNext);
        this.handleType(handleType);
        this.pHostPointer(pHostPointer);
        return this;
    }

    public VkImportMemoryHostPointerInfoEXT set(VkImportMemoryHostPointerInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkImportMemoryHostPointerInfoEXT malloc() {
        return new VkImportMemoryHostPointerInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkImportMemoryHostPointerInfoEXT calloc() {
        return new VkImportMemoryHostPointerInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkImportMemoryHostPointerInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkImportMemoryHostPointerInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkImportMemoryHostPointerInfoEXT create(long address) {
        return new VkImportMemoryHostPointerInfoEXT(address, null);
    }

    @Nullable
    public static VkImportMemoryHostPointerInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkImportMemoryHostPointerInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkImportMemoryHostPointerInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkImportMemoryHostPointerInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkImportMemoryHostPointerInfoEXT mallocStack() {
        return VkImportMemoryHostPointerInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryHostPointerInfoEXT callocStack() {
        return VkImportMemoryHostPointerInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkImportMemoryHostPointerInfoEXT mallocStack(MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkImportMemoryHostPointerInfoEXT callocStack(MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkImportMemoryHostPointerInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkImportMemoryHostPointerInfoEXT.calloc(capacity, stack);
    }

    public static VkImportMemoryHostPointerInfoEXT malloc(MemoryStack stack) {
        return new VkImportMemoryHostPointerInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkImportMemoryHostPointerInfoEXT calloc(MemoryStack stack) {
        return new VkImportMemoryHostPointerInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nhandleType(long struct) {
        return UNSAFE.getInt(null, struct + (long)HANDLETYPE);
    }

    public static long npHostPointer(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER);
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nhandleType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HANDLETYPE, value);
    }

    public static void npHostPointer(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PHOSTPOINTER, Checks.check(value));
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PHOSTPOINTER));
    }

    static {
        Struct.Layout layout = VkImportMemoryHostPointerInfoEXT.__struct(VkImportMemoryHostPointerInfoEXT.__member(4), VkImportMemoryHostPointerInfoEXT.__member(POINTER_SIZE), VkImportMemoryHostPointerInfoEXT.__member(4), VkImportMemoryHostPointerInfoEXT.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        HANDLETYPE = layout.offsetof(2);
        PHOSTPOINTER = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkImportMemoryHostPointerInfoEXT, Buffer>
    implements NativeResource {
        private static final VkImportMemoryHostPointerInfoEXT ELEMENT_FACTORY = VkImportMemoryHostPointerInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkImportMemoryHostPointerInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkImportMemoryHostPointerInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkImportMemoryHostPointerInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkExternalMemoryHandleTypeFlagBits")
        public int handleType() {
            return VkImportMemoryHostPointerInfoEXT.nhandleType(this.address());
        }

        @NativeType(value="void *")
        public long pHostPointer() {
            return VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkImportMemoryHostPointerInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000178000);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkImportMemoryHostPointerInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer handleType(@NativeType(value="VkExternalMemoryHandleTypeFlagBits") int value) {
            VkImportMemoryHostPointerInfoEXT.nhandleType(this.address(), value);
            return this;
        }

        public Buffer pHostPointer(@NativeType(value="void *") long value) {
            VkImportMemoryHostPointerInfoEXT.npHostPointer(this.address(), value);
            return this;
        }
    }
}

