/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.SECURITY_ATTRIBUTES;

public class VkExportMemoryWin32HandleInfoKHR
extends Struct<VkExportMemoryWin32HandleInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PATTRIBUTES;
    public static final int DWACCESS;
    public static final int NAME;

    protected VkExportMemoryWin32HandleInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkExportMemoryWin32HandleInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkExportMemoryWin32HandleInfoKHR(address, container);
    }

    public VkExportMemoryWin32HandleInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkExportMemoryWin32HandleInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkExportMemoryWin32HandleInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkExportMemoryWin32HandleInfoKHR.npNext(this.address());
    }

    @Nullable
    @NativeType(value="SECURITY_ATTRIBUTES const *")
    public SECURITY_ATTRIBUTES pAttributes() {
        return VkExportMemoryWin32HandleInfoKHR.npAttributes(this.address());
    }

    @NativeType(value="DWORD")
    public int dwAccess() {
        return VkExportMemoryWin32HandleInfoKHR.ndwAccess(this.address());
    }

    @NativeType(value="LPCWSTR")
    public ByteBuffer name() {
        return VkExportMemoryWin32HandleInfoKHR.nname(this.address());
    }

    @NativeType(value="LPCWSTR")
    public String nameString() {
        return VkExportMemoryWin32HandleInfoKHR.nnameString(this.address());
    }

    public VkExportMemoryWin32HandleInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkExportMemoryWin32HandleInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR sType$Default() {
        return this.sType(1000073001);
    }

    public VkExportMemoryWin32HandleInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkExportMemoryWin32HandleInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
        VkExportMemoryWin32HandleInfoKHR.npAttributes(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR dwAccess(@NativeType(value="DWORD") int value) {
        VkExportMemoryWin32HandleInfoKHR.ndwAccess(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR name(@NativeType(value="LPCWSTR") ByteBuffer value) {
        VkExportMemoryWin32HandleInfoKHR.nname(this.address(), value);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR set(int sType, long pNext, @Nullable SECURITY_ATTRIBUTES pAttributes, int dwAccess, ByteBuffer name) {
        this.sType(sType);
        this.pNext(pNext);
        this.pAttributes(pAttributes);
        this.dwAccess(dwAccess);
        this.name(name);
        return this;
    }

    public VkExportMemoryWin32HandleInfoKHR set(VkExportMemoryWin32HandleInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkExportMemoryWin32HandleInfoKHR malloc() {
        return new VkExportMemoryWin32HandleInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoKHR calloc() {
        return new VkExportMemoryWin32HandleInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkExportMemoryWin32HandleInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkExportMemoryWin32HandleInfoKHR create(long address) {
        return new VkExportMemoryWin32HandleInfoKHR(address, null);
    }

    @Nullable
    public static VkExportMemoryWin32HandleInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkExportMemoryWin32HandleInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkExportMemoryWin32HandleInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkExportMemoryWin32HandleInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoKHR mallocStack() {
        return VkExportMemoryWin32HandleInfoKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoKHR callocStack() {
        return VkExportMemoryWin32HandleInfoKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoKHR mallocStack(MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoKHR.malloc(stack);
    }

    @Deprecated
    public static VkExportMemoryWin32HandleInfoKHR callocStack(MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkExportMemoryWin32HandleInfoKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkExportMemoryWin32HandleInfoKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkExportMemoryWin32HandleInfoKHR.calloc(capacity, stack);
    }

    public static VkExportMemoryWin32HandleInfoKHR malloc(MemoryStack stack) {
        return new VkExportMemoryWin32HandleInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkExportMemoryWin32HandleInfoKHR calloc(MemoryStack stack) {
        return new VkExportMemoryWin32HandleInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    @Nullable
    public static SECURITY_ATTRIBUTES npAttributes(long struct) {
        return SECURITY_ATTRIBUTES.createSafe(MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES));
    }

    public static int ndwAccess(long struct) {
        return UNSAFE.getInt(null, struct + (long)DWACCESS);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBufferNT2(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memUTF16(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npAttributes(long struct, @Nullable SECURITY_ATTRIBUTES value) {
        MemoryUtil.memPutAddress(struct + (long)PATTRIBUTES, MemoryUtil.memAddressSafe(value));
    }

    public static void ndwAccess(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)DWACCESS, value);
    }

    public static void nname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT2(value);
        }
        MemoryUtil.memPutAddress(struct + (long)NAME, MemoryUtil.memAddress(value));
    }

    public static void validate(long struct) {
        long pAttributes = MemoryUtil.memGetAddress(struct + (long)PATTRIBUTES);
        if (pAttributes != 0L) {
            SECURITY_ATTRIBUTES.validate(pAttributes);
        }
        Checks.check(MemoryUtil.memGetAddress(struct + (long)NAME));
    }

    static {
        Struct.Layout layout = VkExportMemoryWin32HandleInfoKHR.__struct(VkExportMemoryWin32HandleInfoKHR.__member(4), VkExportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE), VkExportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE), VkExportMemoryWin32HandleInfoKHR.__member(4), VkExportMemoryWin32HandleInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PATTRIBUTES = layout.offsetof(2);
        DWACCESS = layout.offsetof(3);
        NAME = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<VkExportMemoryWin32HandleInfoKHR, Buffer>
    implements NativeResource {
        private static final VkExportMemoryWin32HandleInfoKHR ELEMENT_FACTORY = VkExportMemoryWin32HandleInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkExportMemoryWin32HandleInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkExportMemoryWin32HandleInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkExportMemoryWin32HandleInfoKHR.npNext(this.address());
        }

        @Nullable
        @NativeType(value="SECURITY_ATTRIBUTES const *")
        public SECURITY_ATTRIBUTES pAttributes() {
            return VkExportMemoryWin32HandleInfoKHR.npAttributes(this.address());
        }

        @NativeType(value="DWORD")
        public int dwAccess() {
            return VkExportMemoryWin32HandleInfoKHR.ndwAccess(this.address());
        }

        @NativeType(value="LPCWSTR")
        public ByteBuffer name() {
            return VkExportMemoryWin32HandleInfoKHR.nname(this.address());
        }

        @NativeType(value="LPCWSTR")
        public String nameString() {
            return VkExportMemoryWin32HandleInfoKHR.nnameString(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkExportMemoryWin32HandleInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000073001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkExportMemoryWin32HandleInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pAttributes(@Nullable @NativeType(value="SECURITY_ATTRIBUTES const *") SECURITY_ATTRIBUTES value) {
            VkExportMemoryWin32HandleInfoKHR.npAttributes(this.address(), value);
            return this;
        }

        public Buffer dwAccess(@NativeType(value="DWORD") int value) {
            VkExportMemoryWin32HandleInfoKHR.ndwAccess(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="LPCWSTR") ByteBuffer value) {
            VkExportMemoryWin32HandleInfoKHR.nname(this.address(), value);
            return this;
        }
    }
}

