/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkImageCreateInfo;
import org.lwjgl.vulkan.VkImageSubresource2KHR;

public class VkDeviceImageSubresourceInfoKHR
extends Struct<VkDeviceImageSubresourceInfoKHR>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int PCREATEINFO;
    public static final int PSUBRESOURCE;

    protected VkDeviceImageSubresourceInfoKHR(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceImageSubresourceInfoKHR create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceImageSubresourceInfoKHR(address, container);
    }

    public VkDeviceImageSubresourceInfoKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceImageSubresourceInfoKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDeviceImageSubresourceInfoKHR.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDeviceImageSubresourceInfoKHR.npNext(this.address());
    }

    @NativeType(value="VkImageCreateInfo const *")
    public VkImageCreateInfo pCreateInfo() {
        return VkDeviceImageSubresourceInfoKHR.npCreateInfo(this.address());
    }

    @NativeType(value="VkImageSubresource2KHR const *")
    public VkImageSubresource2KHR pSubresource() {
        return VkDeviceImageSubresourceInfoKHR.npSubresource(this.address());
    }

    public VkDeviceImageSubresourceInfoKHR sType(@NativeType(value="VkStructureType") int value) {
        VkDeviceImageSubresourceInfoKHR.nsType(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfoKHR sType$Default() {
        return this.sType(1000470004);
    }

    public VkDeviceImageSubresourceInfoKHR pNext(@NativeType(value="void const *") long value) {
        VkDeviceImageSubresourceInfoKHR.npNext(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfoKHR pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
        VkDeviceImageSubresourceInfoKHR.npCreateInfo(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfoKHR pSubresource(@NativeType(value="VkImageSubresource2KHR const *") VkImageSubresource2KHR value) {
        VkDeviceImageSubresourceInfoKHR.npSubresource(this.address(), value);
        return this;
    }

    public VkDeviceImageSubresourceInfoKHR set(int sType, long pNext, VkImageCreateInfo pCreateInfo, VkImageSubresource2KHR pSubresource) {
        this.sType(sType);
        this.pNext(pNext);
        this.pCreateInfo(pCreateInfo);
        this.pSubresource(pSubresource);
        return this;
    }

    public VkDeviceImageSubresourceInfoKHR set(VkDeviceImageSubresourceInfoKHR src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceImageSubresourceInfoKHR malloc() {
        return new VkDeviceImageSubresourceInfoKHR(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfoKHR calloc() {
        return new VkDeviceImageSubresourceInfoKHR(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfoKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceImageSubresourceInfoKHR(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceImageSubresourceInfoKHR create(long address) {
        return new VkDeviceImageSubresourceInfoKHR(address, null);
    }

    @Nullable
    public static VkDeviceImageSubresourceInfoKHR createSafe(long address) {
        return address == 0L ? null : new VkDeviceImageSubresourceInfoKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceImageSubresourceInfoKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceImageSubresourceInfoKHR.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceImageSubresourceInfoKHR malloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfoKHR(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceImageSubresourceInfoKHR calloc(MemoryStack stack) {
        return new VkDeviceImageSubresourceInfoKHR(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static VkImageCreateInfo npCreateInfo(long struct) {
        return VkImageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
    }

    public static VkImageSubresource2KHR npSubresource(long struct) {
        return VkImageSubresource2KHR.create(MemoryUtil.memGetAddress(struct + (long)PSUBRESOURCE));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void npCreateInfo(long struct, VkImageCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCREATEINFO, value.address());
    }

    public static void npSubresource(long struct, VkImageSubresource2KHR value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBRESOURCE, value.address());
    }

    public static void validate(long struct) {
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PCREATEINFO));
        Checks.check(MemoryUtil.memGetAddress(struct + (long)PSUBRESOURCE));
    }

    static {
        Struct.Layout layout = VkDeviceImageSubresourceInfoKHR.__struct(VkDeviceImageSubresourceInfoKHR.__member(4), VkDeviceImageSubresourceInfoKHR.__member(POINTER_SIZE), VkDeviceImageSubresourceInfoKHR.__member(POINTER_SIZE), VkDeviceImageSubresourceInfoKHR.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        PCREATEINFO = layout.offsetof(2);
        PSUBRESOURCE = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceImageSubresourceInfoKHR, Buffer>
    implements NativeResource {
        private static final VkDeviceImageSubresourceInfoKHR ELEMENT_FACTORY = VkDeviceImageSubresourceInfoKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceImageSubresourceInfoKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDeviceImageSubresourceInfoKHR.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDeviceImageSubresourceInfoKHR.npNext(this.address());
        }

        @NativeType(value="VkImageCreateInfo const *")
        public VkImageCreateInfo pCreateInfo() {
            return VkDeviceImageSubresourceInfoKHR.npCreateInfo(this.address());
        }

        @NativeType(value="VkImageSubresource2KHR const *")
        public VkImageSubresource2KHR pSubresource() {
            return VkDeviceImageSubresourceInfoKHR.npSubresource(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDeviceImageSubresourceInfoKHR.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000470004);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDeviceImageSubresourceInfoKHR.npNext(this.address(), value);
            return this;
        }

        public Buffer pCreateInfo(@NativeType(value="VkImageCreateInfo const *") VkImageCreateInfo value) {
            VkDeviceImageSubresourceInfoKHR.npCreateInfo(this.address(), value);
            return this;
        }

        public Buffer pSubresource(@NativeType(value="VkImageSubresource2KHR const *") VkImageSubresource2KHR value) {
            VkDeviceImageSubresourceInfoKHR.npSubresource(this.address(), value);
            return this;
        }
    }
}

