/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDeviceFaultAddressInfoEXT
extends Struct<VkDeviceFaultAddressInfoEXT>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int ADDRESSTYPE;
    public static final int REPORTEDADDRESS;
    public static final int ADDRESSPRECISION;

    protected VkDeviceFaultAddressInfoEXT(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkDeviceFaultAddressInfoEXT create(long address, @Nullable ByteBuffer container) {
        return new VkDeviceFaultAddressInfoEXT(address, container);
    }

    public VkDeviceFaultAddressInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkDeviceFaultAddressInfoEXT.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkDeviceFaultAddressTypeEXT")
    public int addressType() {
        return VkDeviceFaultAddressInfoEXT.naddressType(this.address());
    }

    @NativeType(value="VkDeviceAddress")
    public long reportedAddress() {
        return VkDeviceFaultAddressInfoEXT.nreportedAddress(this.address());
    }

    @NativeType(value="VkDeviceSize")
    public long addressPrecision() {
        return VkDeviceFaultAddressInfoEXT.naddressPrecision(this.address());
    }

    public VkDeviceFaultAddressInfoEXT addressType(@NativeType(value="VkDeviceFaultAddressTypeEXT") int value) {
        VkDeviceFaultAddressInfoEXT.naddressType(this.address(), value);
        return this;
    }

    public VkDeviceFaultAddressInfoEXT reportedAddress(@NativeType(value="VkDeviceAddress") long value) {
        VkDeviceFaultAddressInfoEXT.nreportedAddress(this.address(), value);
        return this;
    }

    public VkDeviceFaultAddressInfoEXT addressPrecision(@NativeType(value="VkDeviceSize") long value) {
        VkDeviceFaultAddressInfoEXT.naddressPrecision(this.address(), value);
        return this;
    }

    public VkDeviceFaultAddressInfoEXT set(int addressType, long reportedAddress, long addressPrecision) {
        this.addressType(addressType);
        this.reportedAddress(reportedAddress);
        this.addressPrecision(addressPrecision);
        return this;
    }

    public VkDeviceFaultAddressInfoEXT set(VkDeviceFaultAddressInfoEXT src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkDeviceFaultAddressInfoEXT malloc() {
        return new VkDeviceFaultAddressInfoEXT(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkDeviceFaultAddressInfoEXT calloc() {
        return new VkDeviceFaultAddressInfoEXT(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkDeviceFaultAddressInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkDeviceFaultAddressInfoEXT(MemoryUtil.memAddress(container), container);
    }

    public static VkDeviceFaultAddressInfoEXT create(long address) {
        return new VkDeviceFaultAddressInfoEXT(address, null);
    }

    @Nullable
    public static VkDeviceFaultAddressInfoEXT createSafe(long address) {
        return address == 0L ? null : new VkDeviceFaultAddressInfoEXT(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkDeviceFaultAddressInfoEXT.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDeviceFaultAddressInfoEXT.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static VkDeviceFaultAddressInfoEXT malloc(MemoryStack stack) {
        return new VkDeviceFaultAddressInfoEXT(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkDeviceFaultAddressInfoEXT calloc(MemoryStack stack) {
        return new VkDeviceFaultAddressInfoEXT(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int naddressType(long struct) {
        return UNSAFE.getInt(null, struct + (long)ADDRESSTYPE);
    }

    public static long nreportedAddress(long struct) {
        return UNSAFE.getLong(null, struct + (long)REPORTEDADDRESS);
    }

    public static long naddressPrecision(long struct) {
        return UNSAFE.getLong(null, struct + (long)ADDRESSPRECISION);
    }

    public static void naddressType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ADDRESSTYPE, value);
    }

    public static void nreportedAddress(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)REPORTEDADDRESS, value);
    }

    public static void naddressPrecision(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)ADDRESSPRECISION, value);
    }

    static {
        Struct.Layout layout = VkDeviceFaultAddressInfoEXT.__struct(VkDeviceFaultAddressInfoEXT.__member(4), VkDeviceFaultAddressInfoEXT.__member(8), VkDeviceFaultAddressInfoEXT.__member(8));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        ADDRESSTYPE = layout.offsetof(0);
        REPORTEDADDRESS = layout.offsetof(1);
        ADDRESSPRECISION = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<VkDeviceFaultAddressInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDeviceFaultAddressInfoEXT ELEMENT_FACTORY = VkDeviceFaultAddressInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkDeviceFaultAddressInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkDeviceFaultAddressTypeEXT")
        public int addressType() {
            return VkDeviceFaultAddressInfoEXT.naddressType(this.address());
        }

        @NativeType(value="VkDeviceAddress")
        public long reportedAddress() {
            return VkDeviceFaultAddressInfoEXT.nreportedAddress(this.address());
        }

        @NativeType(value="VkDeviceSize")
        public long addressPrecision() {
            return VkDeviceFaultAddressInfoEXT.naddressPrecision(this.address());
        }

        public Buffer addressType(@NativeType(value="VkDeviceFaultAddressTypeEXT") int value) {
            VkDeviceFaultAddressInfoEXT.naddressType(this.address(), value);
            return this;
        }

        public Buffer reportedAddress(@NativeType(value="VkDeviceAddress") long value) {
            VkDeviceFaultAddressInfoEXT.nreportedAddress(this.address(), value);
            return this;
        }

        public Buffer addressPrecision(@NativeType(value="VkDeviceSize") long value) {
            VkDeviceFaultAddressInfoEXT.naddressPrecision(this.address(), value);
            return this;
        }
    }
}

