/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkComponentMapping
extends Struct<VkComponentMapping>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int R;
    public static final int G;
    public static final int B;
    public static final int A;

    protected VkComponentMapping(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected VkComponentMapping create(long address, @Nullable ByteBuffer container) {
        return new VkComponentMapping(address, container);
    }

    public VkComponentMapping(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), VkComponentMapping.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkComponentSwizzle")
    public int r() {
        return VkComponentMapping.nr(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int g() {
        return VkComponentMapping.ng(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int b() {
        return VkComponentMapping.nb(this.address());
    }

    @NativeType(value="VkComponentSwizzle")
    public int a() {
        return VkComponentMapping.na(this.address());
    }

    public VkComponentMapping r(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.nr(this.address(), value);
        return this;
    }

    public VkComponentMapping g(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.ng(this.address(), value);
        return this;
    }

    public VkComponentMapping b(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.nb(this.address(), value);
        return this;
    }

    public VkComponentMapping a(@NativeType(value="VkComponentSwizzle") int value) {
        VkComponentMapping.na(this.address(), value);
        return this;
    }

    public VkComponentMapping set(int r, int g, int b, int a) {
        this.r(r);
        this.g(g);
        this.b(b);
        this.a(a);
        return this;
    }

    public VkComponentMapping set(VkComponentMapping src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static VkComponentMapping malloc() {
        return new VkComponentMapping(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static VkComponentMapping calloc() {
        return new VkComponentMapping(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static VkComponentMapping create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new VkComponentMapping(MemoryUtil.memAddress(container), container);
    }

    public static VkComponentMapping create(long address) {
        return new VkComponentMapping(address, null);
    }

    @Nullable
    public static VkComponentMapping createSafe(long address) {
        return address == 0L ? null : new VkComponentMapping(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(VkComponentMapping.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkComponentMapping.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static VkComponentMapping mallocStack() {
        return VkComponentMapping.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComponentMapping callocStack() {
        return VkComponentMapping.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkComponentMapping mallocStack(MemoryStack stack) {
        return VkComponentMapping.malloc(stack);
    }

    @Deprecated
    public static VkComponentMapping callocStack(MemoryStack stack) {
        return VkComponentMapping.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkComponentMapping.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkComponentMapping.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkComponentMapping.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkComponentMapping.calloc(capacity, stack);
    }

    public static VkComponentMapping malloc(MemoryStack stack) {
        return new VkComponentMapping(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static VkComponentMapping calloc(MemoryStack stack) {
        return new VkComponentMapping(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nr(long struct) {
        return UNSAFE.getInt(null, struct + (long)R);
    }

    public static int ng(long struct) {
        return UNSAFE.getInt(null, struct + (long)G);
    }

    public static int nb(long struct) {
        return UNSAFE.getInt(null, struct + (long)B);
    }

    public static int na(long struct) {
        return UNSAFE.getInt(null, struct + (long)A);
    }

    public static void nr(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)R, value);
    }

    public static void ng(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)G, value);
    }

    public static void nb(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)B, value);
    }

    public static void na(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)A, value);
    }

    static {
        Struct.Layout layout = VkComponentMapping.__struct(VkComponentMapping.__member(4), VkComponentMapping.__member(4), VkComponentMapping.__member(4), VkComponentMapping.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        R = layout.offsetof(0);
        G = layout.offsetof(1);
        B = layout.offsetof(2);
        A = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<VkComponentMapping, Buffer>
    implements NativeResource {
        private static final VkComponentMapping ELEMENT_FACTORY = VkComponentMapping.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected VkComponentMapping getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkComponentSwizzle")
        public int r() {
            return VkComponentMapping.nr(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int g() {
            return VkComponentMapping.ng(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int b() {
            return VkComponentMapping.nb(this.address());
        }

        @NativeType(value="VkComponentSwizzle")
        public int a() {
            return VkComponentMapping.na(this.address());
        }

        public Buffer r(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.nr(this.address(), value);
            return this;
        }

        public Buffer g(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.ng(this.address(), value);
            return this;
        }

        public Buffer b(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.nb(this.address(), value);
            return this;
        }

        public Buffer a(@NativeType(value="VkComponentSwizzle") int value) {
            VkComponentMapping.na(this.address(), value);
            return this;
        }
    }
}

