/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.Buffer;
import java.nio.LongBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.vulkan.VkAllocationCallbacks;
import org.lwjgl.vulkan.VkCommandBuffer;
import org.lwjgl.vulkan.VkDebugUtilsLabelEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCallbackDataEXT;
import org.lwjgl.vulkan.VkDebugUtilsMessengerCreateInfoEXT;
import org.lwjgl.vulkan.VkDebugUtilsObjectNameInfoEXT;
import org.lwjgl.vulkan.VkDebugUtilsObjectTagInfoEXT;
import org.lwjgl.vulkan.VkDevice;
import org.lwjgl.vulkan.VkInstance;
import org.lwjgl.vulkan.VkQueue;

public class EXTDebugUtils {
    public static final int VK_EXT_DEBUG_UTILS_SPEC_VERSION = 2;
    public static final String VK_EXT_DEBUG_UTILS_EXTENSION_NAME = "VK_EXT_debug_utils";
    public static final int VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT = 1000128000;
    public static final int VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT = 1000128001;
    public static final int VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT = 1000128002;
    public static final int VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT = 1000128003;
    public static final int VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT = 1000128004;
    public static final int VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT = 1000128000;
    public static final int VK_DEBUG_UTILS_MESSAGE_SEVERITY_VERBOSE_BIT_EXT = 1;
    public static final int VK_DEBUG_UTILS_MESSAGE_SEVERITY_INFO_BIT_EXT = 16;
    public static final int VK_DEBUG_UTILS_MESSAGE_SEVERITY_WARNING_BIT_EXT = 256;
    public static final int VK_DEBUG_UTILS_MESSAGE_SEVERITY_ERROR_BIT_EXT = 4096;
    public static final int VK_DEBUG_UTILS_MESSAGE_TYPE_GENERAL_BIT_EXT = 1;
    public static final int VK_DEBUG_UTILS_MESSAGE_TYPE_VALIDATION_BIT_EXT = 2;
    public static final int VK_DEBUG_UTILS_MESSAGE_TYPE_PERFORMANCE_BIT_EXT = 4;

    protected EXTDebugUtils() {
        throw new UnsupportedOperationException();
    }

    public static int nvkSetDebugUtilsObjectNameEXT(VkDevice device, long pNameInfo) {
        long __functionAddress = device.getCapabilitiesInstance().vkSetDebugUtilsObjectNameEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        return JNI.callPPI(device.address(), pNameInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkSetDebugUtilsObjectNameEXT(VkDevice device, @NativeType(value="VkDebugUtilsObjectNameInfoEXT const *") VkDebugUtilsObjectNameInfoEXT pNameInfo) {
        return EXTDebugUtils.nvkSetDebugUtilsObjectNameEXT(device, pNameInfo.address());
    }

    public static int nvkSetDebugUtilsObjectTagEXT(VkDevice device, long pTagInfo) {
        long __functionAddress = device.getCapabilitiesInstance().vkSetDebugUtilsObjectTagEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsObjectTagInfoEXT.validate(pTagInfo);
        }
        return JNI.callPPI(device.address(), pTagInfo, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkSetDebugUtilsObjectTagEXT(VkDevice device, @NativeType(value="VkDebugUtilsObjectTagInfoEXT const *") VkDebugUtilsObjectTagInfoEXT pTagInfo) {
        return EXTDebugUtils.nvkSetDebugUtilsObjectTagEXT(device, pTagInfo.address());
    }

    public static void nvkQueueBeginDebugUtilsLabelEXT(VkQueue queue, long pLabelInfo) {
        long __functionAddress = queue.getCapabilitiesInstance().vkQueueBeginDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsLabelEXT.validate(pLabelInfo);
        }
        JNI.callPPV(queue.address(), pLabelInfo, __functionAddress);
    }

    public static void vkQueueBeginDebugUtilsLabelEXT(VkQueue queue, @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT pLabelInfo) {
        EXTDebugUtils.nvkQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo.address());
    }

    public static void vkQueueEndDebugUtilsLabelEXT(VkQueue queue) {
        long __functionAddress = queue.getCapabilitiesInstance().vkQueueEndDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(queue.address(), __functionAddress);
    }

    public static void nvkQueueInsertDebugUtilsLabelEXT(VkQueue queue, long pLabelInfo) {
        long __functionAddress = queue.getCapabilitiesInstance().vkQueueInsertDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsLabelEXT.validate(pLabelInfo);
        }
        JNI.callPPV(queue.address(), pLabelInfo, __functionAddress);
    }

    public static void vkQueueInsertDebugUtilsLabelEXT(VkQueue queue, @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT pLabelInfo) {
        EXTDebugUtils.nvkQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo.address());
    }

    public static void nvkCmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, long pLabelInfo) {
        long __functionAddress = commandBuffer.getCapabilitiesInstance().vkCmdBeginDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsLabelEXT.validate(pLabelInfo);
        }
        JNI.callPPV(commandBuffer.address(), pLabelInfo, __functionAddress);
    }

    public static void vkCmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT pLabelInfo) {
        EXTDebugUtils.nvkCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo.address());
    }

    public static void vkCmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) {
        long __functionAddress = commandBuffer.getCapabilitiesInstance().vkCmdEndDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPV(commandBuffer.address(), __functionAddress);
    }

    public static void nvkCmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, long pLabelInfo) {
        long __functionAddress = commandBuffer.getCapabilitiesInstance().vkCmdInsertDebugUtilsLabelEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsLabelEXT.validate(pLabelInfo);
        }
        JNI.callPPV(commandBuffer.address(), pLabelInfo, __functionAddress);
    }

    public static void vkCmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, @NativeType(value="VkDebugUtilsLabelEXT const *") VkDebugUtilsLabelEXT pLabelInfo) {
        EXTDebugUtils.nvkCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo.address());
    }

    public static int nvkCreateDebugUtilsMessengerEXT(VkInstance instance, long pCreateInfo, long pAllocator, long pMessenger) {
        long __functionAddress = instance.getCapabilities().vkCreateDebugUtilsMessengerEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsMessengerCreateInfoEXT.validate(pCreateInfo);
        }
        return JNI.callPPPPI(instance.address(), pCreateInfo, pAllocator, pMessenger, __functionAddress);
    }

    @NativeType(value="VkResult")
    public static int vkCreateDebugUtilsMessengerEXT(VkInstance instance, @NativeType(value="VkDebugUtilsMessengerCreateInfoEXT const *") VkDebugUtilsMessengerCreateInfoEXT pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDebugUtilsMessengerEXT *") LongBuffer pMessenger) {
        if (Checks.CHECKS) {
            Checks.check((Buffer)pMessenger, 1);
        }
        return EXTDebugUtils.nvkCreateDebugUtilsMessengerEXT(instance, pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), MemoryUtil.memAddress(pMessenger));
    }

    public static void nvkDestroyDebugUtilsMessengerEXT(VkInstance instance, long messenger, long pAllocator) {
        long __functionAddress = instance.getCapabilities().vkDestroyDebugUtilsMessengerEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
        }
        JNI.callPJPV(instance.address(), messenger, pAllocator, __functionAddress);
    }

    public static void vkDestroyDebugUtilsMessengerEXT(VkInstance instance, @NativeType(value="VkDebugUtilsMessengerEXT") long messenger, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator) {
        EXTDebugUtils.nvkDestroyDebugUtilsMessengerEXT(instance, messenger, MemoryUtil.memAddressSafe(pAllocator));
    }

    public static void nvkSubmitDebugUtilsMessageEXT(VkInstance instance, int messageSeverity, int messageTypes, long pCallbackData) {
        long __functionAddress = instance.getCapabilities().vkSubmitDebugUtilsMessageEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            VkDebugUtilsMessengerCallbackDataEXT.validate(pCallbackData);
        }
        JNI.callPPV(instance.address(), messageSeverity, messageTypes, pCallbackData, __functionAddress);
    }

    public static void vkSubmitDebugUtilsMessageEXT(VkInstance instance, @NativeType(value="VkDebugUtilsMessageSeverityFlagBitsEXT") int messageSeverity, @NativeType(value="VkDebugUtilsMessageTypeFlagsEXT") int messageTypes, @NativeType(value="VkDebugUtilsMessengerCallbackDataEXT const *") VkDebugUtilsMessengerCallbackDataEXT pCallbackData) {
        EXTDebugUtils.nvkSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData.address());
    }

    @NativeType(value="VkResult")
    public static int vkCreateDebugUtilsMessengerEXT(VkInstance instance, @NativeType(value="VkDebugUtilsMessengerCreateInfoEXT const *") VkDebugUtilsMessengerCreateInfoEXT pCreateInfo, @Nullable @NativeType(value="VkAllocationCallbacks const *") VkAllocationCallbacks pAllocator, @NativeType(value="VkDebugUtilsMessengerEXT *") long[] pMessenger) {
        long __functionAddress = instance.getCapabilities().vkCreateDebugUtilsMessengerEXT;
        if (Checks.CHECKS) {
            Checks.check(__functionAddress);
            Checks.check(pMessenger, 1);
            VkDebugUtilsMessengerCreateInfoEXT.validate(pCreateInfo.address());
        }
        return JNI.callPPPPI(instance.address(), pCreateInfo.address(), MemoryUtil.memAddressSafe(pAllocator), pMessenger, __functionAddress);
    }
}

