/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiAnimation")
public class AIAnimation
extends Struct<AIAnimation>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MNAME;
    public static final int MDURATION;
    public static final int MTICKSPERSECOND;
    public static final int MNUMCHANNELS;
    public static final int MCHANNELS;
    public static final int MNUMMESHCHANNELS;
    public static final int MMESHCHANNELS;
    public static final int MNUMMORPHMESHCHANNELS;
    public static final int MMORPHMESHCHANNELS;

    protected AIAnimation(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected AIAnimation create(long address, @Nullable ByteBuffer container) {
        return new AIAnimation(address, container);
    }

    public AIAnimation(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), AIAnimation.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="struct aiString")
    public AIString mName() {
        return AIAnimation.nmName(this.address());
    }

    public double mDuration() {
        return AIAnimation.nmDuration(this.address());
    }

    public double mTicksPerSecond() {
        return AIAnimation.nmTicksPerSecond(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumChannels() {
        return AIAnimation.nmNumChannels(this.address());
    }

    @Nullable
    @NativeType(value="struct aiNodeAnim **")
    public PointerBuffer mChannels() {
        return AIAnimation.nmChannels(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMeshChannels() {
        return AIAnimation.nmNumMeshChannels(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMeshAnim **")
    public PointerBuffer mMeshChannels() {
        return AIAnimation.nmMeshChannels(this.address());
    }

    @NativeType(value="unsigned int")
    public int mNumMorphMeshChannels() {
        return AIAnimation.nmNumMorphMeshChannels(this.address());
    }

    @Nullable
    @NativeType(value="struct aiMeshMorphAnim **")
    public PointerBuffer mMorphMeshChannels() {
        return AIAnimation.nmMorphMeshChannels(this.address());
    }

    public AIAnimation mName(@NativeType(value="struct aiString") AIString value) {
        AIAnimation.nmName(this.address(), value);
        return this;
    }

    public AIAnimation mName(Consumer<AIString> consumer) {
        consumer.accept(this.mName());
        return this;
    }

    public AIAnimation mDuration(double value) {
        AIAnimation.nmDuration(this.address(), value);
        return this;
    }

    public AIAnimation mTicksPerSecond(double value) {
        AIAnimation.nmTicksPerSecond(this.address(), value);
        return this;
    }

    public AIAnimation mChannels(@Nullable @NativeType(value="struct aiNodeAnim **") PointerBuffer value) {
        AIAnimation.nmChannels(this.address(), value);
        return this;
    }

    public AIAnimation mMeshChannels(@Nullable @NativeType(value="struct aiMeshAnim **") PointerBuffer value) {
        AIAnimation.nmMeshChannels(this.address(), value);
        return this;
    }

    public AIAnimation mMorphMeshChannels(@Nullable @NativeType(value="struct aiMeshMorphAnim **") PointerBuffer value) {
        AIAnimation.nmMorphMeshChannels(this.address(), value);
        return this;
    }

    public AIAnimation set(AIString mName, double mDuration, double mTicksPerSecond, @Nullable PointerBuffer mChannels, @Nullable PointerBuffer mMeshChannels, @Nullable PointerBuffer mMorphMeshChannels) {
        this.mName(mName);
        this.mDuration(mDuration);
        this.mTicksPerSecond(mTicksPerSecond);
        this.mChannels(mChannels);
        this.mMeshChannels(mMeshChannels);
        this.mMorphMeshChannels(mMorphMeshChannels);
        return this;
    }

    public AIAnimation set(AIAnimation src) {
        MemoryUtil.memCopy(src.address(), this.address(), SIZEOF);
        return this;
    }

    public static AIAnimation malloc() {
        return new AIAnimation(MemoryUtil.nmemAllocChecked(SIZEOF), null);
    }

    public static AIAnimation calloc() {
        return new AIAnimation(MemoryUtil.nmemCallocChecked(1L, SIZEOF), null);
    }

    public static AIAnimation create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return new AIAnimation(MemoryUtil.memAddress(container), container);
    }

    public static AIAnimation create(long address) {
        return new AIAnimation(address, null);
    }

    @Nullable
    public static AIAnimation createSafe(long address) {
        return address == 0L ? null : new AIAnimation(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked(AIAnimation.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIAnimation.__create(capacity, SIZEOF);
        return new Buffer(MemoryUtil.memAddress(container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIAnimation mallocStack() {
        return AIAnimation.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimation callocStack() {
        return AIAnimation.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIAnimation mallocStack(MemoryStack stack) {
        return AIAnimation.malloc(stack);
    }

    @Deprecated
    public static AIAnimation callocStack(MemoryStack stack) {
        return AIAnimation.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIAnimation.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIAnimation.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIAnimation.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIAnimation.calloc(capacity, stack);
    }

    public static AIAnimation malloc(MemoryStack stack) {
        return new AIAnimation(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIAnimation calloc(MemoryStack stack) {
        return new AIAnimation(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static AIString nmName(long struct) {
        return AIString.create(struct + (long)MNAME);
    }

    public static double nmDuration(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MDURATION);
    }

    public static double nmTicksPerSecond(long struct) {
        return UNSAFE.getDouble(null, struct + (long)MTICKSPERSECOND);
    }

    public static int nmNumChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMCHANNELS);
    }

    @Nullable
    public static PointerBuffer nmChannels(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MCHANNELS), AIAnimation.nmNumChannels(struct));
    }

    public static int nmNumMeshChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMESHCHANNELS);
    }

    @Nullable
    public static PointerBuffer nmMeshChannels(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS), AIAnimation.nmNumMeshChannels(struct));
    }

    public static int nmNumMorphMeshChannels(long struct) {
        return UNSAFE.getInt(null, struct + (long)MNUMMORPHMESHCHANNELS);
    }

    @Nullable
    public static PointerBuffer nmMorphMeshChannels(long struct) {
        return MemoryUtil.memPointerBufferSafe(MemoryUtil.memGetAddress(struct + (long)MMORPHMESHCHANNELS), AIAnimation.nmNumMorphMeshChannels(struct));
    }

    public static void nmName(long struct, AIString value) {
        MemoryUtil.memCopy(value.address(), struct + (long)MNAME, AIString.SIZEOF);
    }

    public static void nmDuration(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MDURATION, value);
    }

    public static void nmTicksPerSecond(long struct, double value) {
        UNSAFE.putDouble(null, struct + (long)MTICKSPERSECOND, value);
    }

    public static void nmNumChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMCHANNELS, value);
    }

    public static void nmChannels(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MCHANNELS, MemoryUtil.memAddressSafe(value));
        AIAnimation.nmNumChannels(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMeshChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMESHCHANNELS, value);
    }

    public static void nmMeshChannels(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMESHCHANNELS, MemoryUtil.memAddressSafe(value));
        AIAnimation.nmNumMeshChannels(struct, value == null ? 0 : value.remaining());
    }

    public static void nmNumMorphMeshChannels(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MNUMMORPHMESHCHANNELS, value);
    }

    public static void nmMorphMeshChannels(long struct, @Nullable PointerBuffer value) {
        MemoryUtil.memPutAddress(struct + (long)MMORPHMESHCHANNELS, MemoryUtil.memAddressSafe(value));
        AIAnimation.nmNumMorphMeshChannels(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (AIAnimation.nmNumChannels(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MCHANNELS));
        }
        if (AIAnimation.nmNumMeshChannels(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMESHCHANNELS));
        }
        if (AIAnimation.nmNumMorphMeshChannels(struct) != 0) {
            Checks.check(MemoryUtil.memGetAddress(struct + (long)MMORPHMESHCHANNELS));
        }
    }

    static {
        Struct.Layout layout = AIAnimation.__struct(AIAnimation.__member(AIString.SIZEOF, AIString.ALIGNOF), AIAnimation.__member(8), AIAnimation.__member(8), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE), AIAnimation.__member(4), AIAnimation.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MNAME = layout.offsetof(0);
        MDURATION = layout.offsetof(1);
        MTICKSPERSECOND = layout.offsetof(2);
        MNUMCHANNELS = layout.offsetof(3);
        MCHANNELS = layout.offsetof(4);
        MNUMMESHCHANNELS = layout.offsetof(5);
        MMESHCHANNELS = layout.offsetof(6);
        MNUMMORPHMESHCHANNELS = layout.offsetof(7);
        MMORPHMESHCHANNELS = layout.offsetof(8);
    }

    public static class Buffer
    extends StructBuffer<AIAnimation, Buffer>
    implements NativeResource {
        private static final AIAnimation ELEMENT_FACTORY = AIAnimation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected AIAnimation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="struct aiString")
        public AIString mName() {
            return AIAnimation.nmName(this.address());
        }

        public double mDuration() {
            return AIAnimation.nmDuration(this.address());
        }

        public double mTicksPerSecond() {
            return AIAnimation.nmTicksPerSecond(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumChannels() {
            return AIAnimation.nmNumChannels(this.address());
        }

        @Nullable
        @NativeType(value="struct aiNodeAnim **")
        public PointerBuffer mChannels() {
            return AIAnimation.nmChannels(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMeshChannels() {
            return AIAnimation.nmNumMeshChannels(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMeshAnim **")
        public PointerBuffer mMeshChannels() {
            return AIAnimation.nmMeshChannels(this.address());
        }

        @NativeType(value="unsigned int")
        public int mNumMorphMeshChannels() {
            return AIAnimation.nmNumMorphMeshChannels(this.address());
        }

        @Nullable
        @NativeType(value="struct aiMeshMorphAnim **")
        public PointerBuffer mMorphMeshChannels() {
            return AIAnimation.nmMorphMeshChannels(this.address());
        }

        public Buffer mName(@NativeType(value="struct aiString") AIString value) {
            AIAnimation.nmName(this.address(), value);
            return this;
        }

        public Buffer mName(Consumer<AIString> consumer) {
            consumer.accept(this.mName());
            return this;
        }

        public Buffer mDuration(double value) {
            AIAnimation.nmDuration(this.address(), value);
            return this;
        }

        public Buffer mTicksPerSecond(double value) {
            AIAnimation.nmTicksPerSecond(this.address(), value);
            return this;
        }

        public Buffer mChannels(@Nullable @NativeType(value="struct aiNodeAnim **") PointerBuffer value) {
            AIAnimation.nmChannels(this.address(), value);
            return this;
        }

        public Buffer mMeshChannels(@Nullable @NativeType(value="struct aiMeshAnim **") PointerBuffer value) {
            AIAnimation.nmMeshChannels(this.address(), value);
            return this;
        }

        public Buffer mMorphMeshChannels(@Nullable @NativeType(value="struct aiMeshMorphAnim **") PointerBuffer value) {
            AIAnimation.nmMorphMeshChannels(this.address(), value);
            return this;
        }
    }
}

