/*
 * Decompiled with CFR 0.152.
 */
package poly;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.io.importexport.OsmExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.tools.I18n;
import poly.PolyType;

public class PolyExporter
extends OsmExporter {
    public PolyExporter() {
        super(PolyType.FILE_FILTER);
    }

    public void exportData(File file, Layer layer) throws IOException {
        if (layer instanceof OsmDataLayer) {
            DataSet ds = ((OsmDataLayer)layer).getDataSet();
            if (ds.getWays().stream().anyMatch(w -> w.isUsable() && !w.isClosed())) {
                throw new IOException(I18n.tr((String)"Data contains unclosed ways.", (Object[])new Object[0]));
            }
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]));){
                HashSet<Way> written = new HashSet<Way>();
                boolean firstFile = true;
                String fileName = file.getName();
                if (fileName.lastIndexOf(46) > 0) {
                    fileName = fileName.substring(0, fileName.lastIndexOf(46));
                }
                for (Relation rel : ds.getRelations()) {
                    if (!rel.isUsable() || !rel.isMultipolygon()) continue;
                    if (!firstFile) {
                        writer.println();
                    }
                    PolyExporter.writeRelation(writer, fileName, rel, written);
                    firstFile = false;
                }
                if (firstFile) {
                    writer.println(fileName);
                }
                int counter = 1;
                for (Way w2 : ds.getWays()) {
                    if (!w2.isUsable() || written.contains(w2)) continue;
                    PolyExporter.writeWay(writer, w2, counter);
                }
                writer.println("END");
            }
        }
    }

    private static void writeRelation(PrintWriter writer, String fileName, Relation rel, Set<Way> written) {
        String polygonName = fileName;
        if (rel.getName() != null) {
            polygonName = rel.getName();
        }
        writer.println(polygonName);
        int counter = 1;
        for (RelationMember rm : rel.getMembers()) {
            if (!rm.isWay()) continue;
            if ("inner".equals(rm.getRole())) {
                writer.write(33);
            }
            Way w = rm.getWay();
            counter = PolyExporter.writeWay(writer, w, counter);
            written.add(w);
        }
    }

    private static int writeWay(PrintWriter writer, Way w, int counter) {
        String name = w.getName();
        if (name == null) {
            name = String.valueOf(counter++);
        }
        writer.println(name);
        for (Node n : w.getNodes()) {
            writer.println(String.format(Locale.ENGLISH, "   %f   %f", n.lon(), n.lat()));
        }
        writer.println("END");
        return counter;
    }
}

