/*
 * Decompiled with CFR 0.152.
 */
package org.ejml.dense.row.mult;

import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;

public class MatrixMultQuad {
    public static void multQuad1(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj out) {
        if (A.numCols != B.numCols || A.numCols != B.numRows || A.numRows != out.numRows || A.numRows != out.numCols) {
            throw new IllegalArgumentException("Incompatible matrix shapes");
        }
        CommonOps_DDRM.fill(out, 0.0);
        for (int i = 0; i < A.numRows; ++i) {
            for (int j = 0; j < A.numCols; ++j) {
                double total = 0.0;
                int indexA = i * A.numCols;
                int indexB = j;
                int end = indexA + A.numCols;
                while (indexA < end) {
                    total += A.data[indexA] * B.data[indexB];
                    ++indexA;
                    indexB += B.numCols;
                }
                int indexOut = i * out.numCols;
                indexA = j;
                end = indexOut + A.numRows;
                while (indexOut < end) {
                    int n = indexOut++;
                    out.data[n] = out.data[n] + total * A.data[indexA];
                    indexA += A.numCols;
                }
            }
        }
    }
}

