/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.search;

import java.util.Objects;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.search.PushbackTokenizer;
import org.openstreetmap.josm.data.osm.search.SearchCompiler;

abstract class RangeMatch
extends SearchCompiler.Match {
    private final long min;
    private final long max;

    RangeMatch(long min, long max) {
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    RangeMatch(PushbackTokenizer.Range range) {
        this(range.getStart(), range.getEnd());
    }

    protected abstract Long getNumber(OsmPrimitive var1);

    protected abstract String getString();

    public boolean match(OsmPrimitive osm) {
        Long num = this.getNumber(osm);
        if (num == null) {
            return false;
        }
        return num >= this.min && num <= this.max;
    }

    public String toString() {
        return this.getString() + "=" + this.min + "-" + this.max;
    }

    public int hashCode() {
        return Objects.hash(this.max, this.min);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        RangeMatch other = (RangeMatch)((Object)obj);
        return this.max == other.max && this.min == other.min;
    }
}

