/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.common;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.IntFunction;
import org.apache.commons.imaging.common.AllocationRequestException;

public class Allocator {
    private static final String CANONICAL_NAME = Allocator.class.getCanonicalName();
    private static final int DEFAULT = 0x40000000;
    private static final int LIMIT = Integer.getInteger(CANONICAL_NAME, 0x40000000);

    public static <T> T apply(int request, IntFunction<T> factory) {
        return factory.apply(Allocator.check(request));
    }

    public static <T> T[] array(int request, IntFunction<T[]> factory, int eltShallowByteSize) {
        Allocator.check(request * eltShallowByteSize);
        return factory.apply(request);
    }

    public static <T> ArrayList<T> arrayList(int request) {
        Allocator.check(24 + request * 4);
        return Allocator.apply(request, ArrayList::new);
    }

    public static byte[] byteArray(int request) {
        return new byte[Allocator.checkByteArray(request)];
    }

    public static byte[] byteArray(long request) {
        return new byte[Allocator.check(request, 1)];
    }

    public static char[] charArray(int request) {
        return new char[Allocator.check(request, 2)];
    }

    public static int check(int request) {
        if (request > LIMIT) {
            throw new AllocationRequestException(LIMIT, request);
        }
        return request;
    }

    public static int check(int request, int elementSize) {
        int multiplyExact;
        try {
            multiplyExact = Math.multiplyExact(request, elementSize);
        }
        catch (ArithmeticException e) {
            throw new AllocationRequestException(LIMIT, BigInteger.valueOf(request).multiply(BigInteger.valueOf(elementSize)), (Throwable)e);
        }
        if (multiplyExact > LIMIT) {
            throw new AllocationRequestException(LIMIT, request);
        }
        return request;
    }

    public static int check(long request, int elementSize) {
        try {
            return Allocator.check(Math.toIntExact(request), elementSize);
        }
        catch (ArithmeticException e) {
            throw new AllocationRequestException(LIMIT, request, (Throwable)e);
        }
    }

    public static int checkByteArray(int request) {
        return Allocator.check(request, 1);
    }

    public static double[] doubleArray(int request) {
        return new double[Allocator.check(request, 8)];
    }

    public static float[] floatArray(int request) {
        return new float[Allocator.check(request, 4)];
    }

    public static int[] intArray(int request) {
        return new int[Allocator.check(request, 4)];
    }

    public static long[] longArray(int request) {
        return new long[Allocator.check(request, 8)];
    }

    public static short[] shortArray(int request) {
        return new short[Allocator.check(request, 2)];
    }
}

