/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.geometry.Position;
import org.geotools.geometry.Position2D;

class Polygon
implements Cloneable {
    private Position[] vertices;

    Polygon(Position ... coordinates) {
        this.vertices = coordinates;
    }

    public void setCoordinates(Position ... coordinates) {
        this.vertices = coordinates;
    }

    public Position[] getPoints() {
        return this.vertices;
    }

    public String toString() {
        Object wkt = "";
        for (int i = 0; i < this.vertices.length; ++i) {
            wkt = (String)wkt + this.vertices[i].getCoordinate()[0] + " " + this.vertices[i].getCoordinate()[1];
            if (i == this.vertices.length - 1) continue;
            wkt = (String)wkt + ", ";
        }
        return "LINESTRING (" + (String)wkt + ")";
    }

    protected GeneralPath generateGeneralPath(Position ... points) {
        GeneralPath ring = new GeneralPath();
        ring.moveTo((float)points[0].getCoordinate()[0], (float)points[0].getCoordinate()[1]);
        for (int i = 1; i < points.length; ++i) {
            ring.lineTo((float)points[i].getCoordinate()[0], (float)points[i].getCoordinate()[1]);
        }
        return ring;
    }

    protected boolean containsOrIsVertex(Position dp) {
        return this.generateGeneralPath(this.vertices).contains((Point2D)((Object)dp)) || this.hasVertex(dp);
    }

    public boolean hasVertex(Position p) {
        for (Position vertex : this.vertices) {
            if (p != vertex) continue;
            return true;
        }
        return false;
    }

    protected void enlarge(double scale) {
        double sumX = 0.0;
        double sumY = 0.0;
        for (Position directPosition : this.vertices) {
            sumX += directPosition.getCoordinate()[0];
            sumY += directPosition.getCoordinate()[1];
        }
        sumX /= (double)this.vertices.length;
        sumY /= (double)this.vertices.length;
        for (Position vertex : this.vertices) {
            vertex.getCoordinate()[0] = scale * (vertex.getCoordinate()[0] - sumX) + sumX;
            vertex.getCoordinate()[1] = scale * (vertex.getCoordinate()[1] - sumY) + sumY;
        }
    }

    protected List<Position> reduce() {
        ArrayList<Position> redCoords = new ArrayList<Position>();
        for (Position vertex : this.vertices) {
            redCoords.add(new Position2D(vertex.getCoordinateReferenceSystem(), vertex.getCoordinate()[0] - this.vertices[0].getCoordinate()[0], vertex.getCoordinate()[1] - this.vertices[0].getCoordinate()[1]));
        }
        return redCoords;
    }

    protected boolean containsAll(List<Position> coordinate) {
        for (Position directPosition : coordinate) {
            if (this.containsOrIsVertex(directPosition)) continue;
            return false;
        }
        return true;
    }

    public Polygon clone() {
        return new Polygon(this.vertices);
    }
}

