/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml3.bindings;

import javax.xml.namespace.QName;
import org.geotools.api.geometry.Position;
import org.geotools.geometry.Position2D;
import org.geotools.gml3.GML;
import org.geotools.xsd.AbstractComplexBinding;
import org.geotools.xsd.ElementInstance;
import org.geotools.xsd.Node;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class PointTypeBinding
extends AbstractComplexBinding {
    GeometryFactory gFactory;

    public PointTypeBinding(GeometryFactory gFactory) {
        this.gFactory = gFactory;
    }

    @Override
    public QName getTarget() {
        return GML.PointType;
    }

    @Override
    public int getExecutionMode() {
        return 1;
    }

    public Class getType() {
        return Point.class;
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        if (node.hasChild(Position.class)) {
            Position dp = node.getChildValue(Position.class);
            if (dp instanceof Position2D) {
                return this.gFactory.createPoint(new Coordinate(dp.getOrdinate(0), dp.getOrdinate(1)));
            }
            return this.gFactory.createPoint(new Coordinate(dp.getOrdinate(0), dp.getOrdinate(1), dp.getOrdinate(2)));
        }
        if (node.hasChild(Coordinate.class)) {
            return this.gFactory.createPoint(node.getChildValue(Coordinate.class));
        }
        if (node.hasChild(CoordinateSequence.class)) {
            return this.gFactory.createPoint(node.getChildValue(CoordinateSequence.class));
        }
        return null;
    }

    @Override
    public Object getProperty(Object object, QName name) {
        Geometry geometry = (Geometry)object;
        if (geometry.isEmpty()) {
            return null;
        }
        if ("pos".equals(name.getLocalPart())) {
            Point point = (Point)object;
            return point.getCoordinateSequence();
        }
        return null;
    }
}

