/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function.math;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.util.Converters;

public class ModuloFunction
implements Function {
    static FunctionName NAME = new FunctionNameImpl("modulo", Integer.class, FunctionNameImpl.parameter("dividend", Integer.class), FunctionNameImpl.parameter("divisor", Integer.class));
    private final FunctionName functionName;
    private final List<Expression> parameters;
    private final Literal fallback;

    public ModuloFunction() {
        this.functionName = NAME;
        this.parameters = Collections.emptyList();
        this.fallback = null;
    }

    public ModuloFunction(List<Expression> parameters, Literal fallback) {
        if (parameters == null) {
            throw new NullPointerException("parameters must be provided");
        }
        if (parameters.size() != NAME.getArguments().size()) {
            throw new IllegalArgumentException(NAME.getArguments().size() + " function parameters are required");
        }
        this.functionName = NAME;
        this.parameters = parameters;
        this.fallback = fallback;
    }

    @Override
    public Object evaluate(Object object) {
        return this.evaluate(object, this.functionName.getReturn().getType());
    }

    @Override
    public <T> T evaluate(Object object, Class<T> context) {
        Expression dividendExpression = this.parameters.get(0);
        int dividend = dividendExpression.evaluate(object, Integer.class);
        Expression divisorExpression = this.parameters.get(1);
        int divisor = divisorExpression.evaluate(object, Integer.class);
        if (divisor == 0) {
            throw new IllegalArgumentException("divisor cannot be 0");
        }
        int modulo = dividend - divisor * (int)Math.floor((double)dividend / (double)divisor);
        return Converters.convert(modulo, context);
    }

    @Override
    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit(this, extraData);
    }

    @Override
    public String getName() {
        return this.functionName.getName();
    }

    @Override
    public FunctionName getFunctionName() {
        return this.functionName;
    }

    @Override
    public List<Expression> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public Literal getFallbackValue() {
        return this.fallback;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        sb.append("(");
        List<Expression> params = this.getParameters();
        if (params != null) {
            Iterator<Expression> it = params.iterator();
            while (it.hasNext()) {
                Expression exp = it.next();
                sb.append("[");
                sb.append(exp);
                sb.append("]");
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

