/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.iterators;

import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.util.Arrays;
import javax.media.jai.PlanarImage;
import javax.media.jai.iterator.RandomIter;

public class RandomIterFallbackLarge
implements RandomIter {
    protected RenderedImage im;
    protected Rectangle boundsRect;
    protected SampleModel sampleModel;
    protected int xID = Integer.MIN_VALUE;
    protected int yID = Integer.MIN_VALUE;
    protected int sampleModelTranslateX;
    protected int sampleModelTranslateY;
    protected DataBuffer dataBuffer = null;
    protected int boundsX;
    protected int boundsY;
    protected int[] xTiles;
    protected int[] yTiles;
    private int minTileX;
    private int minTileY;
    private int tileGridXOffset;
    private int tileHeight;
    private int tileGridYOffset;
    private int tileWidth;
    private int currentMaxXInclusive = Integer.MIN_VALUE;
    private int currentMaxYInclusive = Integer.MIN_VALUE;
    private int minx;
    private int miny;
    private int currentMinXInclusive = Integer.MAX_VALUE;
    private int currentMinYInclusive = Integer.MAX_VALUE;

    public RandomIterFallbackLarge(RenderedImage im, Rectangle bounds) {
        this.im = im;
        Rectangle imBounds = new Rectangle(im.getMinX(), im.getMinY(), im.getWidth(), im.getHeight());
        this.boundsRect = imBounds.intersection(bounds);
        this.sampleModel = im.getSampleModel();
        this.boundsX = this.boundsRect.x;
        this.boundsY = this.boundsRect.y;
        this.tileWidth = im.getTileWidth();
        this.tileGridXOffset = im.getTileGridXOffset();
        this.tileHeight = im.getTileHeight();
        this.tileGridYOffset = im.getTileGridYOffset();
        this.minTileX = im.getMinTileX();
        int maxTileXExcluded = this.minTileX + im.getNumXTiles();
        this.minTileY = im.getMinTileY();
        int maxTileYExcluded = this.minTileY + im.getNumYTiles();
        this.xTiles = new int[im.getNumXTiles()];
        this.yTiles = new int[im.getNumYTiles()];
        this.minx = im.getMinX();
        this.miny = im.getMinY();
        int maxx = this.minx + im.getWidth() - 1;
        int maxy = this.miny + im.getHeight() - 1;
        for (int xT = this.minTileX; xT < maxTileXExcluded; ++xT) {
            this.xTiles[xT - this.minTileX] = PlanarImage.tileXToX(xT, this.tileGridXOffset, this.tileWidth) + this.tileWidth - 1;
            this.xTiles[xT - this.minTileX] = Math.min(this.xTiles[xT], maxx);
        }
        for (int yT = this.minTileY; yT < maxTileYExcluded; ++yT) {
            this.yTiles[yT - this.minTileY] = PlanarImage.tileYToY(yT, this.tileGridYOffset, this.tileHeight) + this.tileHeight - 1;
            this.yTiles[yT - this.minTileY] = Math.min(this.yTiles[yT], maxy);
        }
    }

    private void makeCurrent(int xLocal, int yLocal) {
        if (xLocal <= this.currentMaxXInclusive && xLocal >= this.currentMinXInclusive && yLocal <= this.currentMaxYInclusive && yLocal >= this.currentMinYInclusive) {
            return;
        }
        int xIDNew = Arrays.binarySearch(this.xTiles, xLocal);
        if (xIDNew < 0) {
            ++xIDNew;
            xIDNew *= -1;
        }
        xIDNew += this.minTileX;
        int yIDNew = Arrays.binarySearch(this.yTiles, yLocal);
        if (yIDNew < 0) {
            ++yIDNew;
            yIDNew *= -1;
        }
        if (xIDNew != this.xID || (yIDNew += this.minTileY) != this.yID || this.dataBuffer == null) {
            this.xID = xIDNew;
            this.yID = yIDNew;
            this.currentMaxXInclusive = this.xTiles[this.xID - this.minTileX];
            this.currentMaxYInclusive = this.yTiles[this.yID - this.minTileY];
            this.currentMinXInclusive = this.xID - this.minTileX - 1 >= 0 ? this.xTiles[this.xID - this.minTileX - 1] + 1 : this.minx;
            this.currentMinYInclusive = this.yID - this.minTileY - 1 >= 0 ? this.yTiles[this.yID - this.minTileY - 1] + 1 : this.miny;
            Raster tile = this.im.getTile(this.xID, this.yID);
            this.dataBuffer = tile.getDataBuffer();
            this.sampleModelTranslateX = tile.getSampleModelTranslateX();
            this.sampleModelTranslateY = tile.getSampleModelTranslateY();
        }
    }

    @Override
    public int getSample(int x, int y, int b) {
        this.makeCurrent(x, y);
        return this.sampleModel.getSample(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    @Override
    public float getSampleFloat(int x, int y, int b) {
        this.makeCurrent(x, y);
        return this.sampleModel.getSampleFloat(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    @Override
    public double getSampleDouble(int x, int y, int b) {
        this.makeCurrent(x, y);
        return this.sampleModel.getSampleDouble(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, b, this.dataBuffer);
    }

    @Override
    public int[] getPixel(int x, int y, int[] iArray) {
        this.makeCurrent(x, y);
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, iArray, this.dataBuffer);
    }

    @Override
    public float[] getPixel(int x, int y, float[] fArray) {
        this.makeCurrent(x, y);
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, fArray, this.dataBuffer);
    }

    @Override
    public double[] getPixel(int x, int y, double[] dArray) {
        this.makeCurrent(x, y);
        return this.sampleModel.getPixel(x - this.sampleModelTranslateX, y - this.sampleModelTranslateY, dArray, this.dataBuffer);
    }

    @Override
    public void done() {
        this.xTiles = null;
        this.yTiles = null;
        this.dataBuffer = null;
    }
}

