/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.coor.conversion.ICoordinateFormat;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionChoice;
import org.openstreetmap.josm.gui.preferences.projection.ProjectionPreference;
import org.openstreetmap.josm.gui.preferences.projection.SubPrefsOptions;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class ProjectionChooser
extends ExtendedDialog {
    private final JComboBox<ProjectionChoice> projectionCombo = new JComboBox<ProjectionChoice>(ProjectionPreference.getProjectionChoices().toArray(new ProjectionChoice[0]));
    private JPanel projSubPrefPanel;
    private final JPanel projSubPrefPanelWrapper = new JPanel(new GridBagLayout());
    private JLabel projectionCodeLabel;
    private Component projectionCodeGlue;
    private final JLabel projectionCode = new JLabel();
    private JLabel projectionNameLabel;
    private Component projectionNameGlue;
    private final JLabel projectionName = new JLabel();
    private final JLabel bounds = new JLabel();
    private final JPanel projPanel = new JPanel(new GridBagLayout());
    private static final GBC projSubPrefPanelGBC = GBC.std().fill(1).weight(1.0, 1.0);

    public ProjectionChooser(Component parent) {
        this(parent, I18n.tr((String)"Projection method", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
    }

    protected ProjectionChooser(Component parent, String title, String[] buttonTexts) {
        super(parent, title, buttonTexts);
        this.setMinimumSize(new Dimension(600, 200));
        this.addGui();
    }

    public void addGui() {
        this.projectionCodeLabel = new JLabel(I18n.tr((String)"Projection code", (Object[])new Object[0]));
        this.projectionCodeGlue = GBC.glue((int)5, (int)0);
        this.projectionNameLabel = new JLabel(I18n.tr((String)"Projection name", (Object[])new Object[0]));
        this.projectionNameGlue = GBC.glue((int)5, (int)0);
        this.projPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.projPanel.setLayout(new GridBagLayout());
        this.projPanel.add((Component)new JLabel(I18n.tr((String)"Projection method", (Object[])new Object[0])), GBC.std().insets(5, 5, 0, 5));
        this.projPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        this.projPanel.add(this.projectionCombo, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projectionCodeLabel, GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(this.projectionCodeGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionCode, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projectionNameLabel, GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(this.projectionNameGlue, GBC.std().fill(2));
        this.projPanel.add((Component)this.projectionName, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)new JLabel(I18n.tr((String)"Bounds", (Object[])new Object[0])), GBC.std().insets(25, 5, 0, 5));
        this.projPanel.add(GBC.glue((int)5, (int)0), GBC.std().fill(2));
        this.projPanel.add((Component)this.bounds, GBC.eop().fill(2).insets(0, 5, 5, 5));
        this.projPanel.add((Component)this.projSubPrefPanelWrapper, GBC.eol().fill(2).insets(20, 5, 5, 5));
        this.selectedProjectionChanged((ProjectionChoice)this.projectionCombo.getSelectedItem());
        this.projectionCombo.addActionListener(e -> {
            ProjectionChoice pc = (ProjectionChoice)this.projectionCombo.getSelectedItem();
            this.selectedProjectionChanged(pc);
        });
        this.setContent(this.projPanel);
    }

    private void selectedProjectionChanged(ProjectionChoice pc) {
        int size = this.projPanel.getComponentCount();
        if (size < 1) {
            return;
        }
        ActionListener listener = e -> this.updateMeta(pc);
        this.projSubPrefPanelWrapper.removeAll();
        this.projSubPrefPanel = pc.getPreferencePanel(listener);
        this.projSubPrefPanelWrapper.add((Component)this.projSubPrefPanel, projSubPrefPanelGBC);
        this.projPanel.revalidate();
        this.projSubPrefPanel.repaint();
        this.updateMeta(pc);
    }

    private void updateMeta(ProjectionChoice pc) {
        pc.setPreferences(pc.getPreferences(this.projSubPrefPanel));
        Projection proj = pc.getProjection();
        this.projectionCode.setText(proj.toCode());
        this.projectionName.setText(proj.toString());
        Bounds b = proj.getWorldBoundsLatLon();
        ICoordinateFormat cf = CoordinateFormatManager.getDefaultFormat();
        this.bounds.setText(cf.lonToString((ILatLon)b.getMin()) + ", " + cf.latToString((ILatLon)b.getMin()) + " : " + cf.lonToString((ILatLon)b.getMax()) + ", " + cf.latToString((ILatLon)b.getMax()));
        boolean showCode = true;
        boolean showName = false;
        if (pc instanceof SubPrefsOptions) {
            showCode = ((SubPrefsOptions)pc).showProjectionCode();
            showName = ((SubPrefsOptions)pc).showProjectionName();
        }
        this.projectionCodeLabel.setVisible(showCode);
        this.projectionCodeGlue.setVisible(showCode);
        this.projectionCode.setVisible(showCode);
        this.projectionNameLabel.setVisible(showName);
        this.projectionNameGlue.setVisible(showName);
        this.projectionName.setVisible(showName);
    }

    public Projection getProjection() {
        ProjectionChoice pc = (ProjectionChoice)this.projectionCombo.getSelectedItem();
        if (pc != null) {
            Logging.info((String)("Chosen projection: " + pc + " (" + pc.getProjection() + ")"));
            return pc.getProjection();
        }
        return null;
    }

    public ProjectionChooser showDialog() {
        super.showDialog();
        return this;
    }
}

