/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jopendocument.dom.ChildCreator;
import org.jopendocument.dom.XMLVersion;

public class ODXMLDocument {
    private static final Map<XMLVersion, List<Element>> ELEMS_ORDER = new HashMap<XMLVersion, List<Element>>(2);
    private static final Map<String, String> namePrefixes;
    private final Document content;
    private final XMLVersion version;
    private final ChildCreator childCreator;

    private static final List<Element> createChildren(XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getOFFICE();
        ArrayList<Element> arrayList = new ArrayList<Element>(8);
        arrayList.add(new Element("meta", namespace));
        arrayList.add(new Element("settings", namespace));
        arrayList.add(new Element("script", namespace));
        arrayList.add(new Element("font-decls", namespace));
        arrayList.add(new Element("styles", namespace));
        arrayList.add(new Element("automatic-styles", namespace));
        arrayList.add(new Element("master-styles", namespace));
        arrayList.add(new Element("body", namespace));
        return arrayList;
    }

    protected ODXMLDocument(Document document, XMLVersion xMLVersion) {
        if (document == null) {
            throw new NullPointerException("null document");
        }
        this.content = document;
        this.version = xMLVersion;
        this.childCreator = new ChildCreator(this.content.getRootElement(), ELEMS_ORDER.get((Object)this.getVersion()));
    }

    public ODXMLDocument(Document document) {
        this(document, XMLVersion.getVersion(document.getRootElement()));
    }

    public ODXMLDocument(ODXMLDocument oDXMLDocument) {
        this(oDXMLDocument.content.clone(), oDXMLDocument.version);
    }

    public Document getDocument() {
        return this.content;
    }

    public final XMLVersion getVersion() {
        return this.version;
    }

    public final Element getChild(String string) {
        return this.getChild(string, false);
    }

    public Element getChild(String string, boolean bl) {
        return this.childCreator.getChild(this.getVersion().getOFFICE(), string, bl);
    }

    static {
        ELEMS_ORDER.put(XMLVersion.getOOo(), ODXMLDocument.createChildren(XMLVersion.getOOo()));
        ELEMS_ORDER.put(XMLVersion.getOD(), ODXMLDocument.createChildren(XMLVersion.getOD()));
        namePrefixes = new HashMap<String, String>();
        namePrefixes.put("table:table", "table");
        namePrefixes.put("text:a", "office");
        namePrefixes.put("draw:text-box", "draw");
        namePrefixes.put("draw:image", "draw");
        namePrefixes.put("draw:frame", "draw");
    }
}

