/*
 * Decompiled with CFR 0.152.
 */
package org.j7zip.SevenZip.Archive.SevenZip;

import java.io.IOException;
import org.j7zip.Common.BoolVector;
import org.j7zip.Common.ByteBuffer;
import org.j7zip.Common.CRC;
import org.j7zip.Common.IntVector;
import org.j7zip.Common.LongVector;
import org.j7zip.Common.ObjectVector;
import org.j7zip.SevenZip.Archive.Common.BindPair;
import org.j7zip.SevenZip.Archive.SevenZip.AltCoderInfo;
import org.j7zip.SevenZip.Archive.SevenZip.ArchiveDatabaseEx;
import org.j7zip.SevenZip.Archive.SevenZip.CoderInfo;
import org.j7zip.SevenZip.Archive.SevenZip.Decoder;
import org.j7zip.SevenZip.Archive.SevenZip.FileItem;
import org.j7zip.SevenZip.Archive.SevenZip.Folder;
import org.j7zip.SevenZip.Archive.SevenZip.Header;
import org.j7zip.SevenZip.Archive.SevenZip.InArchiveInfo;
import org.j7zip.SevenZip.Archive.SevenZip.InByte2;
import org.j7zip.SevenZip.Archive.SevenZip.StreamSwitch;
import org.j7zip.SevenZip.Common.SequentialOutStreamImp2;
import org.j7zip.SevenZip.Common.StreamUtils;
import org.j7zip.SevenZip.IInStream;

class InArchive
extends Header {
    public static final int kNumMax = Integer.MAX_VALUE;
    public static final int kNumNoIndex = -1;
    IInStream _stream;
    ObjectVector<InByte2> _inByteVector = new ObjectVector();
    InByte2 _inByteBack = new InByte2();
    long _arhiveBeginStreamPosition;
    long _position;
    static final long SECS_BETWEEN_EPOCHS = 11644473600L;
    static final long SECS_TO_100NS = 10000000L;

    public void AddByteStream(byte[] buffer, int size) {
        this._inByteVector.add(new InByte2());
        this._inByteBack = this._inByteVector.Back();
        this._inByteBack.Init(buffer, size);
    }

    void DeleteByteStream() {
        this._inByteVector.DeleteBack();
        if (!this._inByteVector.isEmpty()) {
            this._inByteBack = this._inByteVector.Back();
        }
    }

    static boolean TestSignatureCandidate(byte[] testBytes, int off) {
        for (int i = 0; i < 6; ++i) {
            if (testBytes[i + off] == kSignature[i]) continue;
            return false;
        }
        return true;
    }

    int ReadDirect(IInStream stream, byte[] data, int off, int size) throws IOException {
        int realProcessedSize = StreamUtils.ReadStream(stream, data, off, size);
        if (realProcessedSize != -1) {
            this._position += (long)realProcessedSize;
        }
        return realProcessedSize;
    }

    int ReadDirect(byte[] data, int size) throws IOException {
        return this.ReadDirect(this._stream, data, 0, size);
    }

    int SafeReadDirectUInt32() throws IOException {
        int val = 0;
        byte[] b = new byte[4];
        int realProcessedSize = this.ReadDirect(b, 4);
        if (realProcessedSize != 4) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 4; ++i) {
            val |= (b[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    int ReadUInt32() throws IOException {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int b = this.ReadByte();
            value |= b << 8 * i;
        }
        return value;
    }

    long ReadUInt64() throws IOException {
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            int b = this.ReadByte();
            value |= (long)b << 8 * i;
        }
        return value;
    }

    int ReadBytes(byte[] data, int size) throws IOException {
        if (!this._inByteBack.ReadBytes(data, size)) {
            return -2147467259;
        }
        return 0;
    }

    int ReadByte() throws IOException {
        return this._inByteBack.ReadByte();
    }

    long SafeReadDirectUInt64() throws IOException {
        long val = 0L;
        byte[] b = new byte[8];
        int realProcessedSize = this.ReadDirect(b, 8);
        if (realProcessedSize != 8) {
            throw new IOException("Unexpected End Of Archive");
        }
        for (int i = 0; i < 8; ++i) {
            val |= (long)(b[i] & 0xFF) << 8 * i;
        }
        return val;
    }

    char ReadWideCharLE() throws IOException {
        int b1 = this._inByteBack.ReadByte();
        int b2 = this._inByteBack.ReadByte();
        char c = (char)(((char)b2 << 8) + b1);
        return c;
    }

    long ReadNumber() throws IOException {
        int firstByte = this.ReadByte();
        int mask = 128;
        long value = 0L;
        for (int i = 0; i < 8; ++i) {
            if ((firstByte & mask) == 0) {
                long highPart = firstByte & mask - 1;
                return value += highPart << i * 8;
            }
            int b = this.ReadByte();
            if (b < 0) {
                throw new IOException("ReadNumber - Can't read stream");
            }
            value |= (long)b << 8 * i;
            mask >>= 1;
        }
        return value;
    }

    int ReadNum() throws IOException {
        long value64 = this.ReadNumber();
        if (value64 > Integer.MAX_VALUE) {
            throw new IOException("ReadNum - value > CNum.kNumMax");
        }
        return (int)value64;
    }

    long ReadID() throws IOException {
        return this.ReadNumber();
    }

    int FindAndReadSignature(IInStream stream, long searchHeaderSizeLimit) throws IOException {
        this._position = this._arhiveBeginStreamPosition;
        stream.Seek(this._arhiveBeginStreamPosition, 0);
        byte[] signature = new byte[6];
        int processedSize = this.ReadDirect(stream, signature, 0, 6);
        if (processedSize != 6) {
            return 1;
        }
        if (InArchive.TestSignatureCandidate(signature, 0)) {
            return 0;
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        int kBufferSize = 65536;
        byteBuffer.SetCapacity(65536);
        byte[] buffer = byteBuffer.data();
        int numPrevBytes = 5;
        System.arraycopy(signature, 1, buffer, 0, numPrevBytes);
        long curTestPos = this._arhiveBeginStreamPosition + 1L;
        while (searchHeaderSizeLimit == -1L || curTestPos - this._arhiveBeginStreamPosition <= searchHeaderSizeLimit) {
            int numReadBytes = 65536 - numPrevBytes;
            processedSize = this.ReadDirect(stream, buffer, numPrevBytes, numReadBytes);
            if (processedSize == -1) {
                return 1;
            }
            int numBytesInBuffer = numPrevBytes + processedSize;
            if (numBytesInBuffer < 6) break;
            int numTests = numBytesInBuffer - 6 + 1;
            int pos = 0;
            while (pos < numTests) {
                if (InArchive.TestSignatureCandidate(buffer, pos)) {
                    this._arhiveBeginStreamPosition = curTestPos;
                    this._position = curTestPos + 6L;
                    stream.Seek(this._position, 0);
                    return 0;
                }
                ++pos;
                ++curTestPos;
            }
            numPrevBytes = numBytesInBuffer - numTests;
            System.arraycopy(buffer, numTests, buffer, 0, numPrevBytes);
        }
        return 1;
    }

    int SkeepData(long size) throws IOException {
        for (long i = 0L; i < size; ++i) {
            this.ReadByte();
        }
        return 0;
    }

    int SkeepData() throws IOException {
        long size = this.ReadNumber();
        return this.SkeepData(size);
    }

    int ReadArchiveProperties(InArchiveInfo archiveInfo) throws IOException {
        long type;
        while ((type = this.ReadID()) != 0L) {
            this.SkeepData();
        }
        return 0;
    }

    int GetNextFolderItem(Folder folder) throws IOException {
        int i;
        int numCoders = this.ReadNum();
        folder.Coders.clear();
        folder.Coders.Reserve(numCoders);
        int numInStreams = 0;
        int numOutStreams = 0;
        for (i = 0; i < numCoders; ++i) {
            int mainByte;
            folder.Coders.add(new CoderInfo());
            CoderInfo coder = folder.Coders.Back();
            do {
                coder.AltCoders.add(new AltCoderInfo());
                AltCoderInfo altCoder = coder.AltCoders.Back();
                mainByte = this.ReadByte();
                altCoder.MethodID.IDSize = (byte)(mainByte & 0xF);
                int ret = this.ReadBytes(altCoder.MethodID.ID, altCoder.MethodID.IDSize);
                if (ret != 0) {
                    return ret;
                }
                if ((mainByte & 0x10) != 0) {
                    coder.NumInStreams = this.ReadNum();
                    coder.NumOutStreams = this.ReadNum();
                } else {
                    coder.NumInStreams = 1;
                    coder.NumOutStreams = 1;
                }
                if ((mainByte & 0x20) == 0) continue;
                int propertiesSize = this.ReadNum();
                altCoder.Properties.SetCapacity(propertiesSize);
                ret = this.ReadBytes(altCoder.Properties.data(), propertiesSize);
            } while ((mainByte & 0x80) != 0);
            numInStreams += coder.NumInStreams;
            numOutStreams += coder.NumOutStreams;
        }
        int numBindPairs = numOutStreams - 1;
        folder.BindPairs.clear();
        folder.BindPairs.Reserve(numBindPairs);
        for (i = 0; i < numBindPairs; ++i) {
            BindPair bindPair = new BindPair();
            bindPair.InIndex = this.ReadNum();
            bindPair.OutIndex = this.ReadNum();
            folder.BindPairs.add(bindPair);
        }
        int numPackedStreams = numInStreams - numBindPairs;
        folder.PackStreams.Reserve(numPackedStreams);
        if (numPackedStreams == 1) {
            for (int j = 0; j < numInStreams; ++j) {
                if (folder.FindBindPairForInStream(j) >= 0) continue;
                folder.PackStreams.add(j);
                break;
            }
        } else {
            for (i = 0; i < numPackedStreams; ++i) {
                int packStreamInfo = this.ReadNum();
                folder.PackStreams.add(packStreamInfo);
            }
        }
        return 0;
    }

    int WaitAttribute(long attribute) throws IOException {
        int ret;
        do {
            long type;
            if ((type = this.ReadID()) == attribute) {
                return 0;
            }
            if (type != 0L) continue;
            return 1;
        } while ((ret = this.SkeepData()) == 0);
        return ret;
    }

    int Open(IInStream stream, long searchHeaderSizeLimit) throws IOException {
        this.Close();
        this._position = this._arhiveBeginStreamPosition = stream.Seek(0L, 1);
        int ret = this.FindAndReadSignature(stream, searchHeaderSizeLimit);
        if (ret != 0) {
            return ret;
        }
        this._stream = stream;
        return 0;
    }

    void Close() throws IOException {
        if (this._stream != null) {
            this._stream.close();
        }
        this._stream = null;
    }

    int ReadStreamsInfo(ObjectVector<ByteBuffer> dataVector, long[] dataOffset, LongVector packSizes, BoolVector packCRCsDefined, IntVector packCRCs, ObjectVector<Folder> folders, IntVector numUnPackStreamsInFolders, LongVector unPackSizes, BoolVector digestsDefined, IntVector digests) throws IOException {
        while (true) {
            long type = this.ReadID();
            switch ((int)type) {
                case 0: {
                    return 0;
                }
                case 6: {
                    int result = this.ReadPackInfo(dataOffset, packSizes, packCRCsDefined, packCRCs);
                    if (result == 0) break;
                    return result;
                }
                case 7: {
                    int result = this.ReadUnPackInfo(dataVector, folders);
                    if (result == 0) break;
                    return result;
                }
                case 8: {
                    int result = this.ReadSubStreamsInfo(folders, numUnPackStreamsInFolders, unPackSizes, digestsDefined, digests);
                    if (result == 0) break;
                    return result;
                }
            }
        }
    }

    int ReadFileNames(ObjectVector<FileItem> files) throws IOException {
        for (int i = 0; i < files.size(); ++i) {
            char c;
            Object name = new String();
            while ((c = this.ReadWideCharLE()) != '\u0000') {
                name = (String)name + c;
            }
            ((FileItem)files.get((int)i)).name = name;
        }
        return 0;
    }

    int ReadBoolVector(int numItems, BoolVector v) throws IOException {
        v.clear();
        v.Reserve(numItems);
        int b = 0;
        int mask = 0;
        for (int i = 0; i < numItems; ++i) {
            if (mask == 0) {
                b = this.ReadByte();
                mask = 128;
            }
            v.add((b & mask) != 0);
            mask >>= 1;
        }
        return 0;
    }

    int ReadBoolVector2(int numItems, BoolVector v) throws IOException {
        int allAreDefined = this.ReadByte();
        if (allAreDefined == 0) {
            return this.ReadBoolVector(numItems, v);
        }
        v.clear();
        v.Reserve(numItems);
        for (int i = 0; i < numItems; ++i) {
            v.add(true);
        }
        return 0;
    }

    int ReadHashDigests(int numItems, BoolVector digestsDefined, IntVector digests) throws IOException {
        int ret = this.ReadBoolVector2(numItems, digestsDefined);
        if (ret != 0) {
            return ret;
        }
        digests.clear();
        digests.Reserve(numItems);
        for (int i = 0; i < numItems; ++i) {
            int crc = 0;
            if (digestsDefined.get(i)) {
                crc = this.ReadUInt32();
            }
            digests.add(crc);
        }
        return 0;
    }

    int ReadPackInfo(long[] dataOffset, LongVector packSizes, BoolVector packCRCsDefined, IntVector packCRCs) throws IOException {
        long type;
        dataOffset[0] = this.ReadNumber();
        int numPackStreams = this.ReadNum();
        int ret = this.WaitAttribute(9L);
        if (ret != 0) {
            return ret;
        }
        packSizes.clear();
        packSizes.Reserve(numPackStreams);
        for (int i = 0; i < numPackStreams; ++i) {
            long size = this.ReadNumber();
            packSizes.add(size);
        }
        while ((type = this.ReadID()) != 0L) {
            if (!(type == 10L ? (ret = this.ReadHashDigests(numPackStreams, packCRCsDefined, packCRCs)) != 0 : (ret = this.SkeepData()) != 0)) continue;
            return ret;
        }
        if (packCRCsDefined.isEmpty()) {
            packCRCsDefined.Reserve(numPackStreams);
            packCRCsDefined.clear();
            packCRCs.Reserve(numPackStreams);
            packCRCs.clear();
            for (int i = 0; i < numPackStreams; ++i) {
                packCRCsDefined.add(false);
                packCRCs.add(0);
            }
        }
        return 0;
    }

    int ReadUnPackInfo(ObjectVector<ByteBuffer> dataVector, ObjectVector<Folder> folders) throws IOException {
        int ret = this.WaitAttribute(11L);
        if (ret != 0) {
            return ret;
        }
        int numFolders = this.ReadNum();
        StreamSwitch streamSwitch = new StreamSwitch();
        ret = streamSwitch.Set(this, dataVector);
        if (ret != 0) {
            return ret;
        }
        folders.clear();
        folders.Reserve(numFolders);
        for (int i = 0; i < numFolders; ++i) {
            folders.add(new Folder());
            ret = this.GetNextFolderItem(folders.Back());
            if (ret == 0) continue;
            streamSwitch.close();
            return ret;
        }
        streamSwitch.close();
        ret = this.WaitAttribute(12L);
        if (ret != 0) {
            return ret;
        }
        for (int i = 0; i < numFolders; ++i) {
            Folder folder = (Folder)folders.get(i);
            int numOutStreams = folder.GetNumOutStreams();
            folder.UnPackSizes.Reserve(numOutStreams);
            for (int j = 0; j < numOutStreams; ++j) {
                long unPackSize = this.ReadNumber();
                folder.UnPackSizes.add(unPackSize);
            }
        }
        block3: while (true) {
            long type;
            if ((type = this.ReadID()) == 0L) {
                return 0;
            }
            if (type == 10L) {
                BoolVector crcsDefined = new BoolVector();
                IntVector crcs = new IntVector();
                ret = this.ReadHashDigests(numFolders, crcsDefined, crcs);
                if (ret != 0) {
                    return ret;
                }
                int i = 0;
                while (true) {
                    if (i >= numFolders) continue block3;
                    Folder folder = (Folder)folders.get(i);
                    folder.UnPackCRCDefined = crcsDefined.get(i);
                    folder.UnPackCRC = crcs.get(i);
                    ++i;
                }
            }
            ret = this.SkeepData();
            if (ret != 0) break;
        }
        return ret;
    }

    int ReadSubStreamsInfo(ObjectVector<Folder> folders, IntVector numUnPackStreamsInFolders, LongVector unPackSizes, BoolVector digestsDefined, IntVector digests) throws IOException {
        int i;
        long type;
        block21: {
            int ret;
            numUnPackStreamsInFolders.clear();
            numUnPackStreamsInFolders.Reserve(folders.size());
            block0: while (true) {
                if ((type = this.ReadID()) == 13L) {
                    i = 0;
                    while (true) {
                        if (i >= folders.size()) continue block0;
                        int value = this.ReadNum();
                        numUnPackStreamsInFolders.add(value);
                        ++i;
                    }
                }
                if (type == 10L || type == 9L || type == 0L) break block21;
                ret = this.SkeepData();
                if (ret != 0) break;
            }
            return ret;
        }
        if (numUnPackStreamsInFolders.isEmpty()) {
            for (i = 0; i < folders.size(); ++i) {
                numUnPackStreamsInFolders.add(1);
            }
        }
        for (i = 0; i < numUnPackStreamsInFolders.size(); ++i) {
            int numSubstreams = numUnPackStreamsInFolders.get(i);
            if (numSubstreams == 0) continue;
            long sum = 0L;
            for (int j = 1; j < numSubstreams; ++j) {
                if (type != 9L) continue;
                long size = this.ReadNumber();
                unPackSizes.add(size);
                sum += size;
            }
            unPackSizes.add(((Folder)folders.get(i)).GetUnPackSize() - sum);
        }
        if (type == 9L) {
            type = this.ReadID();
        }
        int numDigests = 0;
        int numDigestsTotal = 0;
        for (int i2 = 0; i2 < folders.size(); ++i2) {
            int numSubstreams = numUnPackStreamsInFolders.get(i2);
            if (numSubstreams != 1 || !((Folder)folders.get((int)i2)).UnPackCRCDefined) {
                numDigests += numSubstreams;
            }
            numDigestsTotal += numSubstreams;
        }
        while (true) {
            if (type == 10L) {
                BoolVector digestsDefined2 = new BoolVector();
                IntVector digests2 = new IntVector();
                int ret = this.ReadHashDigests(numDigests, digestsDefined2, digests2);
                if (ret != 0) {
                    return ret;
                }
                int digestIndex = 0;
                for (int i3 = 0; i3 < folders.size(); ++i3) {
                    int numSubstreams = numUnPackStreamsInFolders.get(i3);
                    Folder folder = (Folder)folders.get(i3);
                    if (numSubstreams == 1 && folder.UnPackCRCDefined) {
                        digestsDefined.add(true);
                        digests.add(folder.UnPackCRC);
                        continue;
                    }
                    int j = 0;
                    while (j < numSubstreams) {
                        digestsDefined.add(digestsDefined2.get(digestIndex));
                        digests.add(digests2.get(digestIndex));
                        ++j;
                        ++digestIndex;
                    }
                }
            } else {
                if (type == 0L) {
                    if (digestsDefined.isEmpty()) {
                        digestsDefined.clear();
                        digests.clear();
                        for (int i4 = 0; i4 < numDigestsTotal; ++i4) {
                            digestsDefined.add(false);
                            digests.add(0);
                        }
                    }
                    return 0;
                }
                int ret = this.SkeepData();
                if (ret != 0) {
                    return ret;
                }
            }
            type = this.ReadID();
        }
    }

    static long FileTimeToLong(int dwHighDateTime, int dwLowDateTime) {
        long tm = dwHighDateTime;
        tm <<= 32;
        return ((tm |= (long)dwLowDateTime & 0xFFFFFFFFL) - 116444736000000000L) / 10000L;
    }

    int ReadTime(ObjectVector<ByteBuffer> dataVector, ObjectVector<FileItem> files, long type) throws IOException {
        BoolVector boolVector = new BoolVector();
        int ret = this.ReadBoolVector2(files.size(), boolVector);
        if (ret != 0) {
            return ret;
        }
        StreamSwitch streamSwitch = new StreamSwitch();
        ret = streamSwitch.Set(this, dataVector);
        if (ret != 0) {
            streamSwitch.close();
            return ret;
        }
        block3: for (int i = 0; i < files.size(); ++i) {
            FileItem file = (FileItem)files.get(i);
            int low = 0;
            int high = 0;
            boolean defined = boolVector.get(i);
            if (defined) {
                low = this.ReadUInt32();
                high = this.ReadUInt32();
            }
            switch ((int)type) {
                case 20: {
                    if (!defined) continue block3;
                    file.LastWriteTime = InArchive.FileTimeToLong(high, low);
                }
            }
        }
        streamSwitch.close();
        return 0;
    }

    int ReadAndDecodePackedStreams(long baseOffset, long[] dataOffset, ObjectVector<ByteBuffer> dataVector) throws IOException {
        LongVector packSizes = new LongVector();
        BoolVector packCRCsDefined = new BoolVector();
        IntVector packCRCs = new IntVector();
        ObjectVector<Folder> folders = new ObjectVector<Folder>();
        IntVector numUnPackStreamsInFolders = new IntVector();
        LongVector unPackSizes = new LongVector();
        BoolVector digestsDefined = new BoolVector();
        IntVector digests = new IntVector();
        this.ReadStreamsInfo(null, dataOffset, packSizes, packCRCsDefined, packCRCs, folders, numUnPackStreamsInFolders, unPackSizes, digestsDefined, digests);
        int packIndex = 0;
        Decoder decoder = new Decoder(false);
        long dataStartPos = baseOffset + dataOffset[0];
        for (int i = 0; i < folders.size(); ++i) {
            SequentialOutStreamImp2 outStreamSpec;
            Folder folder = (Folder)folders.get(i);
            dataVector.add(new ByteBuffer());
            ByteBuffer data = dataVector.Back();
            long unPackSize = folder.GetUnPackSize();
            if (unPackSize > Integer.MAX_VALUE) {
                return -2147467259;
            }
            if (unPackSize > 0xFFFFFFFFL) {
                return -2147467259;
            }
            data.SetCapacity((int)unPackSize);
            SequentialOutStreamImp2 outStream = outStreamSpec = new SequentialOutStreamImp2();
            outStreamSpec.Init(data.data(), (int)unPackSize);
            int result = decoder.Decode(this._stream, dataStartPos, packSizes, packIndex, folder, outStream, null);
            if (result != 0) {
                return result;
            }
            if (folder.UnPackCRCDefined && !CRC.VerifyDigest(folder.UnPackCRC, data.data(), (int)unPackSize)) {
                throw new IOException("Incorrect Header");
            }
            for (int j = 0; j < folder.PackStreams.size(); ++j) {
                dataStartPos += packSizes.get(packIndex++);
            }
        }
        return 0;
    }

    int ReadDatabase(ArchiveDatabaseEx database) throws IOException {
        long type;
        database.Clear();
        byte[] btmp = new byte[2];
        int realProcessedSize = this.ReadDirect(btmp, 2);
        if (realProcessedSize != 2) {
            throw new IOException("Unexpected End Of Archive");
        }
        database.ArchiveInfo.ArchiveVersion_Major = btmp[0];
        if (database.ArchiveInfo.ArchiveVersion_Major != kMajorVersion) {
            throw new IOException("Unsupported Version");
        }
        CRC crc = new CRC();
        int crcFromArchive = this.SafeReadDirectUInt32();
        long nextHeaderOffset = this.SafeReadDirectUInt64();
        long nextHeaderSize = this.SafeReadDirectUInt64();
        int nextHeaderCRC = this.SafeReadDirectUInt32();
        crc.UpdateUInt64(nextHeaderOffset);
        crc.UpdateUInt64(nextHeaderSize);
        crc.UpdateUInt32(nextHeaderCRC);
        database.ArchiveInfo.StartPositionAfterHeader = this._position;
        if (crc.GetDigest() != crcFromArchive) {
            throw new IOException("Incorrect Header");
        }
        if (nextHeaderSize == 0L) {
            return 0;
        }
        if (nextHeaderSize >= 0xFFFFFFFFL) {
            return -2147467259;
        }
        this._position = this._stream.Seek(nextHeaderOffset, 1);
        ByteBuffer buffer2 = new ByteBuffer();
        buffer2.SetCapacity((int)nextHeaderSize);
        realProcessedSize = this.ReadDirect(buffer2.data(), (int)nextHeaderSize);
        if (realProcessedSize != (int)nextHeaderSize) {
            throw new IOException("Unexpected End Of Archive");
        }
        if (!CRC.VerifyDigest(nextHeaderCRC, buffer2.data(), (int)nextHeaderSize)) {
            throw new IOException("Incorrect Header");
        }
        StreamSwitch streamSwitch = new StreamSwitch();
        streamSwitch.Set(this, buffer2);
        ObjectVector<ByteBuffer> dataVector = new ObjectVector<ByteBuffer>();
        while ((type = this.ReadID()) != 1L) {
            if (type != 23L) {
                throw new IOException("Incorrect Header");
            }
            long[] ltmp = new long[]{database.ArchiveInfo.DataStartPosition2};
            int result = this.ReadAndDecodePackedStreams(database.ArchiveInfo.StartPositionAfterHeader, ltmp, dataVector);
            if (result != 0) {
                return result;
            }
            database.ArchiveInfo.DataStartPosition2 = ltmp[0];
            if (dataVector.size() == 0) {
                return 0;
            }
            if (dataVector.size() > 1) {
                throw new IOException("Incorrect Header");
            }
            streamSwitch.Remove();
            streamSwitch.Set(this, (ByteBuffer)dataVector.get(0));
        }
        streamSwitch.close();
        return this.ReadHeader(database);
    }

    int ReadHeader(ArchiveDatabaseEx database) throws IOException {
        long type = this.ReadID();
        if (type == 2L) {
            int ret = this.ReadArchiveProperties(database.ArchiveInfo);
            if (ret != 0) {
                return ret;
            }
            type = this.ReadID();
        }
        ObjectVector<ByteBuffer> dataVector = new ObjectVector<ByteBuffer>();
        if (type == 3L) {
            long[] ltmp = new long[]{database.ArchiveInfo.DataStartPosition2};
            int result = this.ReadAndDecodePackedStreams(database.ArchiveInfo.StartPositionAfterHeader, ltmp, dataVector);
            if (result != 0) {
                return result;
            }
            database.ArchiveInfo.DataStartPosition2 = ltmp[0];
            database.ArchiveInfo.DataStartPosition2 += database.ArchiveInfo.StartPositionAfterHeader;
            type = this.ReadID();
        }
        LongVector unPackSizes = new LongVector();
        BoolVector digestsDefined = new BoolVector();
        IntVector digests = new IntVector();
        if (type == 4L) {
            long[] ltmp = new long[]{database.ArchiveInfo.DataStartPosition};
            int result = this.ReadStreamsInfo(dataVector, ltmp, database.PackSizes, database.PackCRCsDefined, database.PackCRCs, database.Folders, database.NumUnPackStreamsVector, unPackSizes, digestsDefined, digests);
            if (result != 0) {
                return result;
            }
            database.ArchiveInfo.DataStartPosition = ltmp[0];
            database.ArchiveInfo.DataStartPosition += database.ArchiveInfo.StartPositionAfterHeader;
            type = this.ReadID();
        } else {
            for (int i = 0; i < database.Folders.size(); ++i) {
                database.NumUnPackStreamsVector.add(1);
                Folder folder = (Folder)database.Folders.get(i);
                unPackSizes.add(folder.GetUnPackSize());
                digestsDefined.add(folder.UnPackCRCDefined);
                digests.add(folder.UnPackCRC);
            }
        }
        database.Files.clear();
        if (type == 0L) {
            return 0;
        }
        if (type != 5L) {
            throw new IOException("Incorrect Header");
        }
        int numFiles = this.ReadNum();
        database.Files.Reserve(numFiles);
        for (int i = 0; i < numFiles; ++i) {
            database.Files.add(new FileItem());
        }
        database.ArchiveInfo.FileInfoPopIDs.add(9L);
        if (!database.PackSizes.isEmpty()) {
            database.ArchiveInfo.FileInfoPopIDs.add(6L);
        }
        if (numFiles > 0 && !digests.isEmpty()) {
            database.ArchiveInfo.FileInfoPopIDs.add(10L);
        }
        BoolVector emptyStreamVector = new BoolVector();
        emptyStreamVector.Reserve(numFiles);
        for (int i = 0; i < numFiles; ++i) {
            emptyStreamVector.add(false);
        }
        BoolVector emptyFileVector = new BoolVector();
        BoolVector antiFileVector = new BoolVector();
        int numEmptyStreams = 0;
        block12: while ((type = this.ReadID()) != 0L) {
            long size = this.ReadNumber();
            database.ArchiveInfo.FileInfoPopIDs.add(type);
            switch ((int)type) {
                case 17: {
                    StreamSwitch streamSwitch = new StreamSwitch();
                    int result = streamSwitch.Set(this, dataVector);
                    if (result != 0) {
                        return result;
                    }
                    result = this.ReadFileNames(database.Files);
                    streamSwitch.close();
                    if (result == 0) continue block12;
                    return result;
                }
                case 21: {
                    FileItem file;
                    int i;
                    BoolVector boolVector = new BoolVector();
                    int result = this.ReadBoolVector2(database.Files.size(), boolVector);
                    if (result != 0) {
                        return result;
                    }
                    StreamSwitch streamSwitch = new StreamSwitch();
                    result = streamSwitch.Set(this, dataVector);
                    if (result != 0) {
                        return result;
                    }
                    for (i = 0; i < numFiles; ++i) {
                        file = (FileItem)database.Files.get(i);
                        file.AreAttributesDefined = boolVector.get(i);
                        if (!file.AreAttributesDefined) continue;
                        file.Attributes = this.ReadUInt32();
                    }
                    streamSwitch.close();
                    break;
                }
                case 24: {
                    FileItem file;
                    int i;
                    BoolVector boolVector = new BoolVector();
                    int result = this.ReadBoolVector2(database.Files.size(), boolVector);
                    if (result != 0) {
                        return result;
                    }
                    StreamSwitch streamSwitch = new StreamSwitch();
                    result = streamSwitch.Set(this, dataVector);
                    if (result != 0) {
                        return result;
                    }
                    for (i = 0; i < numFiles; ++i) {
                        file = (FileItem)database.Files.get(i);
                        file.IsStartPosDefined = boolVector.get(i);
                        if (!file.IsStartPosDefined) continue;
                        file.StartPos = this.ReadUInt64();
                    }
                    streamSwitch.close();
                    break;
                }
                case 14: {
                    int i;
                    int result = this.ReadBoolVector(numFiles, emptyStreamVector);
                    if (result != 0) {
                        return result;
                    }
                    for (i = 0; i < emptyStreamVector.size(); ++i) {
                        if (!emptyStreamVector.get(i)) continue;
                        ++numEmptyStreams;
                    }
                    emptyFileVector.Reserve(numEmptyStreams);
                    antiFileVector.Reserve(numEmptyStreams);
                    for (i = 0; i < numEmptyStreams; ++i) {
                        emptyFileVector.add(false);
                        antiFileVector.add(false);
                    }
                    continue block12;
                }
                case 15: {
                    int result = this.ReadBoolVector(numEmptyStreams, emptyFileVector);
                    if (result == 0) continue block12;
                    return result;
                }
                case 16: {
                    int result = this.ReadBoolVector(numEmptyStreams, antiFileVector);
                    if (result == 0) continue block12;
                    return result;
                }
                case 18: 
                case 19: 
                case 20: {
                    int result = this.ReadTime(dataVector, database.Files, type);
                    if (result == 0) continue block12;
                    return result;
                }
                default: {
                    database.ArchiveInfo.FileInfoPopIDs.DeleteBack();
                    int result = this.SkeepData(size);
                    if (result == 0) continue block12;
                    return result;
                }
            }
        }
        int emptyFileIndex = 0;
        int sizeIndex = 0;
        for (int i = 0; i < numFiles; ++i) {
            FileItem file = (FileItem)database.Files.get(i);
            boolean bl = file.HasStream = !emptyStreamVector.get(i);
            if (file.HasStream) {
                file.IsDirectory = false;
                file.IsAnti = false;
                file.UnPackSize = unPackSizes.get(sizeIndex);
                file.FileCRC = digests.get(sizeIndex);
                file.IsFileCRCDefined = digestsDefined.get(sizeIndex);
                ++sizeIndex;
                continue;
            }
            file.IsDirectory = !emptyFileVector.get(emptyFileIndex);
            file.IsAnti = antiFileVector.get(emptyFileIndex);
            ++emptyFileIndex;
            file.UnPackSize = 0L;
            file.IsFileCRCDefined = false;
        }
        return 0;
    }
}

