/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.commandline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GraphicsEnvironment;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.DisableShortcutsOnFocusGainedTextField;
import org.openstreetmap.josm.io.GpxWriter;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.commandline.AnyAction;
import org.openstreetmap.josm.plugins.commandline.Command;
import org.openstreetmap.josm.plugins.commandline.CommandAction;
import org.openstreetmap.josm.plugins.commandline.CommandLineAction;
import org.openstreetmap.josm.plugins.commandline.DummyAction;
import org.openstreetmap.josm.plugins.commandline.GpxFilter;
import org.openstreetmap.josm.plugins.commandline.History;
import org.openstreetmap.josm.plugins.commandline.LengthAction;
import org.openstreetmap.josm.plugins.commandline.Loader;
import org.openstreetmap.josm.plugins.commandline.Mode;
import org.openstreetmap.josm.plugins.commandline.NodeAction;
import org.openstreetmap.josm.plugins.commandline.OsmToCmd;
import org.openstreetmap.josm.plugins.commandline.Parameter;
import org.openstreetmap.josm.plugins.commandline.PointAction;
import org.openstreetmap.josm.plugins.commandline.RelationAction;
import org.openstreetmap.josm.plugins.commandline.Relay;
import org.openstreetmap.josm.plugins.commandline.Type;
import org.openstreetmap.josm.plugins.commandline.WayAction;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;
import org.openstreetmap.josm.tools.Utils;

public class CommandLine
extends Plugin {
    protected JTextField textField;
    protected JTextField historyField;
    private String prefix;
    private Mode mode;
    private ArrayList<Command> commands;
    private JMenu commandMenu;
    protected Command currentCommand;
    protected String commandSymbol = ": ";
    protected History history = new History(100);
    protected MapFrame currentMapFrame;
    static final String pluginDir = Preferences.main().getPluginsDirectory().getAbsolutePath() + "/CommandLine/";

    public CommandLine(PluginInformation info) {
        super(info);
        this.historyField = new DisableShortcutsOnFocusGainedTextField();
        this.textField = new CommandTextField();
        MainMenu mainMenu = MainApplication.getMenu();
        if (mainMenu != null) {
            this.commandMenu = mainMenu.addMenu("Commands", I18n.tr((String)"Commands", (Object[])new Object[0]), 79, mainMenu.getDefaultMenuPos(), HelpUtil.ht((String)"/Plugin/CommandLine"));
            MainMenu.add((JMenu)this.commandMenu, (JosmAction)new CommandLineAction(this));
        }
        this.loadCommands();
        this.setMode(Mode.IDLE);
    }

    public void startCommand(String commandName) {
        Command command = this.findCommand(commandName, true);
        if (command != null) {
            this.startCommand(command);
        }
    }

    protected void startCommand(Command command) {
        MapFrame map = MainApplication.getMap();
        if (map == null) {
            return;
        }
        DataSet ds = MainApplication.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        this.currentCommand = command;
        this.currentCommand.resetLoading();
        this.parseSelection(ds.getSelected());
        if (this.currentCommand.currentParameterNum < this.currentCommand.parameters.size()) {
            this.setMode(Mode.SELECTION);
        } else {
            this.runTool();
        }
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        this.currentMapFrame = newFrame;
        if (oldFrame == null && newFrame != null) {
            JToolBar tb = new JToolBar();
            tb.setLayout(new BorderLayout());
            tb.setFloatable(false);
            tb.setOrientation(0);
            tb.add((Component)this.historyField, "North");
            tb.add((Component)this.textField, "South");
            this.currentMapFrame.add((Component)tb, (Object)"North");
            this.printHistory("Loaded CommandLine, version " + this.getPluginInformation().version);
        }
    }

    protected void printHistory(String text) {
        SwingUtilities.invokeLater(() -> this.historyField.setText(text));
    }

    private void loadCommands() {
        this.commands = new Loader(this.getPluginDirs().getUserDataDirectory(false)).load();
        if (this.commands.isEmpty() && !GraphicsEnvironment.isHeadless() && 0 == JOptionPane.showConfirmDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"No command has been found. Would you like to download and install default commands now?", (Object[])new Object[0]), I18n.tr((String)"No command found", (Object[])new Object[0]), 1)) {
            try {
                this.downloadAndInstallDefaultCommands();
                this.commands = new Loader(this.getPluginDirs().getUserDataDirectory(false)).load();
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Default commands have been successfully installed", (Object[])new Object[0]), I18n.tr((String)"Success", (Object[])new Object[0]), 1);
            }
            catch (IOException e) {
                Logging.warn((Throwable)e);
                JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Failed to download and install default commands.\n\nError: {0}", (Object[])new Object[]{e.getMessage()}), I18n.tr((String)"Warning", (Object[])new Object[0]), 2);
            }
        }
        for (Command command : this.commands) {
            this.commandMenu.add((Action)((Object)new CommandAction(command, this)));
        }
    }

    private void downloadAndInstallDefaultCommands() throws IOException {
        String url = Config.getPref().get("commandline.default.commands.url", "https://github.com/Foxhind/JOSM-CommandLine-commands/archive/master.zip");
        try (ZipInputStream zis = new ZipInputStream(HttpClient.create((URL)new URL(url)).connect().getContent(), StandardCharsets.UTF_8);){
            File dir = this.getPluginDirs().getUserDataDirectory(false);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                if (name.contains("/")) {
                    name = name.substring(name.lastIndexOf("/"));
                }
                File file = new File(dir + File.separator + name);
                Logging.info((String)("Installing command file: " + file));
                if (!file.createNewFile()) {
                    throw new IOException("Could not create file: " + file.getAbsolutePath());
                }
                Files.copy(zis, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                long time = entry.getTime();
                if (time <= -1L) continue;
                file.setLastModified(time);
            }
        }
    }

    private Command findCommand(String text, boolean strict) {
        for (int i = 0; i < this.commands.size(); ++i) {
            if (!(strict ? this.commands.get((int)i).name.equalsIgnoreCase(text) : this.commands.get((int)i).name.toLowerCase().startsWith(text.toLowerCase()) && text.length() > 1)) continue;
            return this.commands.get(i);
        }
        return null;
    }

    protected void setMode(Mode targetMode) {
        DataSet currentDataSet = MainApplication.getLayerManager().getEditDataSet();
        if (currentDataSet != null) {
            currentDataSet.clearSelection();
            MainApplication.getMap().mapView.repaint();
        }
        if (targetMode == Mode.IDLE) {
            this.mode = Mode.IDLE;
            this.currentCommand = null;
            this.prefix = I18n.tr((String)"Command", (Object[])new Object[0]) + this.commandSymbol;
            this.textField.setText(this.prefix);
        } else if (targetMode == Mode.SELECTION) {
            this.mode = Mode.SELECTION;
            Parameter currentParameter = this.currentCommand.parameters.get(this.currentCommand.currentParameterNum);
            this.prefix = I18n.tr((String)(currentParameter.description == null ? currentParameter.name : currentParameter.description), (Object[])new Object[0]);
            if (currentParameter.getRawValue() instanceof Relay) {
                this.prefix = this.prefix + " (" + ((Relay)currentParameter.getRawValue()).getOptionsString() + ")";
            }
            this.prefix = this.prefix + this.commandSymbol;
            String value = currentParameter.getValue();
            this.textField.setText(this.prefix + value);
            Type currentType = currentParameter.type;
            MapMode action = null;
            switch (currentType) {
                case POINT: {
                    action = new PointAction(this);
                    break;
                }
                case WAY: {
                    action = new WayAction(this);
                    break;
                }
                case NODE: {
                    action = new NodeAction(this);
                    break;
                }
                case RELATION: {
                    action = new RelationAction(this);
                    break;
                }
                case ANY: {
                    action = new AnyAction(this);
                    break;
                }
                case LENGTH: {
                    action = new LengthAction(this);
                    break;
                }
                case USERNAME: {
                    this.loadParameter(Config.getPref().get("osm-server.username", null), true);
                    action = new DummyAction(this);
                    break;
                }
                case IMAGERYURL: {
                    Layer layer = MainApplication.getLayerManager().getActiveLayer();
                    if (layer != null && !(layer instanceof ImageryLayer)) {
                        List imageryLayers = MainApplication.getLayerManager().getLayersOfType(ImageryLayer.class);
                        if (imageryLayers.size() == 1) {
                            layer = (Layer)imageryLayers.get(0);
                        } else {
                            this.endInput();
                            return;
                        }
                    }
                    if (layer != null) {
                        ImageryInfo info = ((ImageryLayer)layer).getInfo();
                        String url = info.getUrl();
                        this.loadParameter(url.isEmpty() ? info.getImageryType().getTypeString() : url, true);
                    }
                    action = new DummyAction(this);
                    break;
                }
                case IMAGERYOFFSET: {
                    Layer olayer = MainApplication.getLayerManager().getActiveLayer();
                    if (olayer != null && !(olayer instanceof AbstractTileSourceLayer)) {
                        List imageryLayers = MainApplication.getLayerManager().getLayersOfType(AbstractTileSourceLayer.class);
                        if (imageryLayers.size() == 1) {
                            olayer = (Layer)imageryLayers.get(0);
                        } else {
                            this.endInput();
                            return;
                        }
                    }
                    this.loadParameter(String.valueOf(((AbstractTileSourceLayer)olayer).getDisplaySettings().getDx()) + "," + String.valueOf(((AbstractTileSourceLayer)olayer).getDisplaySettings().getDy()), true);
                    action = new DummyAction(this);
                    break;
                }
                default: {
                    action = new DummyAction(this);
                }
            }
            this.currentMapFrame.selectMapMode(action);
            this.activate();
            this.textField.select(this.prefix.length(), this.textField.getText().length());
        } else if (targetMode == Mode.PROCESSING) {
            this.mode = Mode.PROCESSING;
            this.prefix = I18n.tr((String)"Processing...", (Object[])new Object[0]);
            this.textField.setText(this.prefix);
            MainApplication.getMap().mapView.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public void activate() {
        this.textField.requestFocus();
        this.textField.setCaretPosition(this.textField.getText().length());
    }

    public void deactivate() {
        MainApplication.getMap().mapView.requestFocus();
    }

    public void abortInput() {
        this.printHistory(I18n.tr((String)"Aborted", (Object[])new Object[0]) + ".");
        this.endInput();
    }

    public void endInput() {
        this.setMode(Mode.IDLE);
        MainApplication.getMap().selectMapMode(null);
        MainApplication.getMap().mapView.repaint();
    }

    public void loadParameter(Object obj, boolean next) {
        if (this.currentCommand.loadObject(obj)) {
            if (this.currentCommand.hasNextParameter()) {
                if (next) {
                    Parameter currentParameter = this.currentCommand.parameters.get(this.currentCommand.currentParameterNum);
                    Object prefix = I18n.tr((String)(currentParameter.description == null ? currentParameter.name : currentParameter.description), (Object[])new Object[0]);
                    prefix = (String)prefix + this.commandSymbol;
                    String value = currentParameter.getValue();
                    this.printHistory((String)prefix + value);
                    this.currentCommand.nextParameter();
                    this.setMode(Mode.SELECTION);
                }
            } else {
                this.runTool();
            }
        } else {
            Logging.info((String)"Invalid argument");
            this.endInput();
        }
    }

    private void parseSelection(Collection<OsmPrimitive> selection) {
        OsmPrimitive obj;
        boolean ok = false;
        Iterator<OsmPrimitive> iterator = selection.iterator();
        while (iterator.hasNext() && (ok = this.currentCommand.loadObject(obj = iterator.next()))) {
        }
        if (ok) {
            this.currentCommand.nextParameter();
        } else {
            this.currentCommand.resetLoading();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTool() {
        this.setMode(Mode.PROCESSING);
        String commandToRun = this.currentCommand.run;
        boolean tracks = this.currentCommand.tracks;
        ArrayList<Parameter> parameters = this.currentCommand.parameters;
        for (Parameter parameter : this.currentCommand.parameters) {
            commandToRun = commandToRun.replace("{" + parameter.name + "}", parameter.getValue());
        }
        for (Parameter parameter : this.currentCommand.optParameters) {
            commandToRun = commandToRun.replace("{" + parameter.name + "}", parameter.getValue());
        }
        String[] listToRun = commandToRun.split(" ");
        final Object syncObj = new Object();
        ProcessBuilder builder = new ProcessBuilder(listToRun);
        builder.directory(this.getPluginDirs().getUserDataDirectory(false));
        StringBuilder debugstr = new StringBuilder();
        for (String s : builder.command()) {
            debugstr.append(s + " ");
        }
        debugstr.append("\n");
        Logging.info((String)debugstr.toString());
        final ToolProcess tp = new ToolProcess();
        try {
            tp.process = builder.start();
        }
        catch (IOException e) {
            String errorText;
            StringBuilder stringBuilder = debugstr;
            synchronized (stringBuilder) {
                errorText = I18n.tr((String)"Error executing the script:", (Object[])new Object[0]) + " " + debugstr + e.getMessage();
            }
            Logging.error((String)errorText);
            Logging.error((Throwable)e);
            GuiHelper.runInEDT(() -> new Notification(errorText).setIcon(0).setDuration(Notification.TIME_LONG).show());
            this.setMode(Mode.IDLE);
            return;
        }
        tp.running = true;
        new Thread(() -> {
            try {
                int len;
                byte[] buffer = new byte[1024];
                InputStream errStream = tp.process.getErrorStream();
                while ((len = errStream.read(buffer)) > 0) {
                    StringBuilder stringBuilder = debugstr;
                    synchronized (stringBuilder) {
                        debugstr.append(new String(buffer, 0, len, StandardCharsets.UTF_8));
                    }
                    System.err.write(buffer, 0, len);
                }
            }
            catch (IOException e) {
                Logging.warn((Throwable)e);
            }
        }).start();
        Thread osmWriteThread = new Thread(() -> {
            BBox bbox = null;
            OutputStream outputStream = tp.process.getOutputStream();
            PrintWriter printWriter = null;
            try {
                printWriter = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
            }
            catch (Exception e1) {
                Logging.error((Throwable)e1);
            }
            OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(printWriter, (boolean)true, null);
            Collection<OsmPrimitive> refObjects = this.currentCommand.getDepsObjects();
            osmWriter.header();
            ArrayList<OsmPrimitive> contents = new ArrayList<OsmPrimitive>();
            for (OsmPrimitive primitive1 : refObjects) {
                contents.add(primitive1);
                if (bbox == null) {
                    bbox = new BBox(primitive1.getBBox());
                    continue;
                }
                bbox.addPrimitive(primitive1, 0.0);
            }
            osmWriter.writeNodes((Collection)new SubclassFilteredCollection(contents, Node.class::isInstance));
            osmWriter.writeWays((Collection)new SubclassFilteredCollection(contents, Way.class::isInstance));
            osmWriter.writeRelations((Collection)new SubclassFilteredCollection(contents, Relation.class::isInstance));
            osmWriter.footer();
            osmWriter.flush();
            for (Parameter parameter : parameters) {
                if (!parameter.isOsm()) continue;
                contents = new ArrayList();
                osmWriter.header();
                Collection<OsmPrimitive> pObjects = parameter.getParameterObjects();
                for (OsmPrimitive primitive2 : pObjects) {
                    contents.add(primitive2);
                    if (bbox == null) {
                        bbox = new BBox(primitive2.getBBox());
                        continue;
                    }
                    bbox.addPrimitive(primitive2, 0.0);
                }
                osmWriter.writeNodes((Collection)new SubclassFilteredCollection(contents, Node.class::isInstance));
                osmWriter.writeWays((Collection)new SubclassFilteredCollection(contents, Way.class::isInstance));
                osmWriter.writeRelations((Collection)new SubclassFilteredCollection(contents, Relation.class::isInstance));
                osmWriter.footer();
                osmWriter.flush();
            }
            if (tracks) {
                try (GpxWriter gpxWriter = new GpxWriter(printWriter);){
                    GpxFilter gpxFilter = new GpxFilter();
                    gpxFilter.initBboxFilter(bbox);
                    List gpxLayers = MainApplication.getLayerManager().getLayersOfType(GpxLayer.class);
                    for (GpxLayer gpxLayer : gpxLayers) {
                        gpxFilter.addGpxData(gpxLayer.data);
                    }
                    gpxWriter.write(gpxFilter.getGpxData());
                }
                catch (IOException e2) {
                    Logging.warn((Throwable)e2);
                }
            }
            Utils.close((Closeable)osmWriter);
            Object object = syncObj;
            synchronized (object) {
                if (this.currentCommand.asynchronous) {
                    tp.running = false;
                    syncObj.notifyAll();
                }
            }
        });
        DataSet currentDataSet = MainApplication.getLayerManager().getEditDataSet();
        CommandLine that = this;
        Thread osmParseThread = new Thread(() -> {
            try {
                OsmToCmd osmToCmd = new OsmToCmd(that, currentDataSet);
                String commandName = this.currentCommand.name;
                InputStream inputStream = tp.process.getInputStream();
                osmToCmd.parseStream(inputStream);
                LinkedList<org.openstreetmap.josm.command.Command> cmdlist = osmToCmd.getCommandList();
                if (!cmdlist.isEmpty()) {
                    SequenceCommand cmd = new SequenceCommand(commandName, cmdlist);
                    SwingUtilities.invokeLater(() -> UndoRedoHandler.getInstance().add((org.openstreetmap.josm.command.Command)cmd));
                }
            }
            catch (Exception e) {
                Logging.warn((Throwable)e);
            }
            finally {
                Object object = syncObj;
                synchronized (object) {
                    tp.running = false;
                    syncObj.notifyAll();
                }
            }
        });
        osmParseThread.start();
        osmWriteThread.start();
        Object object = syncObj;
        synchronized (object) {
            try {
                syncObj.wait(Config.getPref().getInt("commandline.timeout", 20000));
            }
            catch (InterruptedException e) {
                Logging.warn((Throwable)e);
            }
        }
        if (tp.running) {
            new Thread((Runnable)new PleaseWaitRunnable(this.currentCommand.name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void realRun() {
                    try {
                        this.progressMonitor.indeterminateSubTask(null);
                        Object object = syncObj;
                        synchronized (object) {
                            if (tp.running) {
                                syncObj.wait();
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        Logging.warn((Throwable)e);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void cancel() {
                    Object object = syncObj;
                    synchronized (object) {
                        tp.running = false;
                        tp.process.destroy();
                        syncObj.notifyAll();
                        CommandLine.this.endInput();
                    }
                }

                protected void finish() {
                }
            }).start();
        }
        this.endInput();
    }

    private static class ToolProcess {
        public Process process;
        public volatile boolean running;

        private ToolProcess() {
        }
    }

    private final class CommandTextField
    extends DisableShortcutsOnFocusGainedTextField {
        private CommandTextField() {
        }

        protected void processKeyEvent(KeyEvent e) {
            Command command;
            if (e.getID() == 401) {
                int code = e.getKeyCode();
                if (code == 10) {
                    String commandText = CommandLine.this.textField.getText().substring(CommandLine.this.prefix.length());
                    switch (CommandLine.this.mode) {
                        case IDLE: {
                            if (commandText.isEmpty()) {
                                commandText = CommandLine.this.history.getLastItem();
                            } else {
                                CommandLine.this.history.addItem(commandText);
                            }
                            Command command2 = CommandLine.this.findCommand(commandText, true);
                            if (command2 != null) {
                                CommandLine.this.startCommand(command2);
                                break;
                            }
                            CommandLine.this.setMode(Mode.IDLE);
                            break;
                        }
                        case SELECTION: {
                            if (CommandLine.this.currentMapFrame.mapMode instanceof WayAction || CommandLine.this.currentMapFrame.mapMode instanceof NodeAction || CommandLine.this.currentMapFrame.mapMode instanceof RelationAction || CommandLine.this.currentMapFrame.mapMode instanceof AnyAction) {
                                Collection selected = MainApplication.getLayerManager().getEditDataSet().getSelected();
                                if (selected.isEmpty()) break;
                                CommandLine.this.loadParameter(selected, true);
                                break;
                            }
                            CommandLine.this.loadParameter(commandText, CommandLine.this.currentCommand.parameters.get((int)CommandLine.this.currentCommand.currentParameterNum).maxInstances == 1);
                            break;
                        }
                    }
                    e.consume();
                } else if (code == 38) {
                    CommandLine.this.textField.setText(CommandLine.this.prefix + CommandLine.this.history.getPrevItem());
                    e.consume();
                } else if (code == 40) {
                    CommandLine.this.textField.setText(CommandLine.this.prefix + CommandLine.this.history.getNextItem());
                    e.consume();
                } else if (code == 8 || code == 37) {
                    if (CommandLine.this.textField.getCaretPosition() <= CommandLine.this.prefix.length()) {
                        e.consume();
                    }
                } else if (code == 36) {
                    this.setCaretPosition(CommandLine.this.prefix.length());
                    e.consume();
                } else if (code == 27) {
                    if (CommandLine.this.textField.getText().length() == CommandLine.this.prefix.length() && CommandLine.this.mode == Mode.IDLE) {
                        CommandLine.this.deactivate();
                    } else {
                        CommandLine.this.endInput();
                    }
                    e.consume();
                } else if (code != 127 && code != 39 && code != 35) {
                    e.consume();
                }
                if (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length() || CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length() && CommandLine.this.textField.getSelectionStart() > 0) {
                    e.consume();
                }
            }
            if (e.getID() == 400 && (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length() || CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length() && CommandLine.this.textField.getSelectionStart() > 0)) {
                e.consume();
            }
            super.processKeyEvent(e);
            if (CommandLine.this.textField.getText().length() < CommandLine.this.prefix.length()) {
                CommandLine.this.setMode(CommandLine.this.mode);
            }
            if (e.getID() == 400 && e.getKeyChar() > 'A' && e.getKeyChar() < 'z' && (command = CommandLine.this.findCommand(CommandLine.this.textField.getText().substring(CommandLine.this.prefix.length()), false)) != null) {
                int currentPos = CommandLine.this.textField.getSelectionStart() == 0 ? CommandLine.this.textField.getCaretPosition() : CommandLine.this.textField.getSelectionStart();
                CommandLine.this.textField.setText(CommandLine.this.prefix + command.name);
                CommandLine.this.textField.setCaretPosition(currentPos);
                CommandLine.this.textField.select(currentPos, CommandLine.this.prefix.length() + command.name.length());
            }
        }

        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            if (e.getButton() == 1 && e.getID() == 502) {
                if (CommandLine.this.textField.getSelectionStart() > 0 && CommandLine.this.textField.getSelectionStart() < CommandLine.this.prefix.length()) {
                    CommandLine.this.textField.setSelectionStart(CommandLine.this.prefix.length());
                } else if (CommandLine.this.textField.getCaretPosition() < CommandLine.this.prefix.length()) {
                    CommandLine.this.textField.setCaretPosition(CommandLine.this.prefix.length());
                }
            }
        }
    }
}

