/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.hot.sds;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.openstreetmap.hot.sds.SdsApi;
import org.openstreetmap.hot.sds.SdsParser;
import org.openstreetmap.hot.sds.SdsTransferException;
import org.openstreetmap.hot.sds.SeparateDataStorePlugin;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.OsmPrimitiveVisitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReadPostprocessor;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadPostprocessor
implements OsmServerReadPostprocessor {
    private ArrayList<Long> nodeList;
    private ArrayList<Long> wayList;
    private ArrayList<Long> relationList;
    private SeparateDataStorePlugin plugin;

    public ReadPostprocessor(SeparateDataStorePlugin plugin) {
        this.plugin = plugin;
    }

    public void postprocessDataSet(DataSet ds, ProgressMonitor progress) {
        this.nodeList = new ArrayList();
        this.wayList = new ArrayList();
        this.relationList = new ArrayList();
        OsmPrimitiveVisitor adder = new OsmPrimitiveVisitor(){

            public void visit(Node n) {
                ReadPostprocessor.this.nodeList.add(n.getId());
                ReadPostprocessor.this.plugin.originalNodes.put(n.getId(), (IPrimitive)n.save());
            }

            public void visit(Way w) {
                ReadPostprocessor.this.wayList.add(w.getId());
                ReadPostprocessor.this.plugin.originalWays.put(w.getId(), (IPrimitive)w.save());
            }

            public void visit(Relation e) {
                ReadPostprocessor.this.relationList.add(e.getId());
                ReadPostprocessor.this.plugin.originalNodes.put(e.getId(), (IPrimitive)e.save());
            }
        };
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (p.isNew()) continue;
            p.accept(adder);
        }
        if (this.nodeList.isEmpty() && this.wayList.isEmpty() && this.relationList.isEmpty()) {
            return;
        }
        SdsApi api = SdsApi.getSdsApi();
        String rv = "";
        try {
            rv = api.requestShadowsFromSds(this.nodeList, this.wayList, this.relationList, progress);
        }
        catch (SdsTransferException e) {
            Logging.error((Throwable)e);
        }
        try {
            ByteArrayInputStream xmlStream = new ByteArrayInputStream(rv.getBytes("UTF-8"));
            InputSource inputSource = new InputSource(xmlStream);
            SAXParserFactory.newInstance().newSAXParser().parse(inputSource, (DefaultHandler)new SdsParser(ds, this.plugin));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Logging.error((Throwable)e);
        }
    }
}

