/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.actions;

import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.ChangeMembersCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PasteRelationsAction
extends JosmAction {
    private static final String TITLE = I18n.tr((String)"Paste Relations", (Object[])new Object[0]);

    public PasteRelationsAction() {
        super(TITLE, "dumbutils/pasterelations", I18n.tr((String)"Paste relation membership from objects in the buffer onto selected object(s)", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:pasterelations", (String)I18n.tr((String)"More tools: {0}", (Object[])new Object[]{I18n.tr((String)"Paste Relations", (Object[])new Object[0])}), (int)65535, (int)5000), true);
    }

    public void actionPerformed(ActionEvent e) {
        Collection selection = this.getLayerManager().getEditDataSet().getSelected();
        if (selection.isEmpty()) {
            return;
        }
        HashMap<Relation, String> relations = new HashMap<Relation, String>();
        Collection<Object> data = Collections.emptySet();
        try {
            data = ((PrimitiveTransferData)ClipboardUtils.getClipboard().getData(PrimitiveTransferData.DATA_FLAVOR)).getDirectlyAdded();
        }
        catch (UnsupportedFlavorException | IOException ex) {
            Logging.warn((Throwable)ex);
        }
        for (PrimitiveData pdata : data) {
            OsmPrimitive p = (OsmPrimitive)this.getLayerManager().getEditDataSet().getPrimitiveById(pdata.getUniqueId(), pdata.getType());
            if (p == null) continue;
            for (Relation r : Utils.filteredCollection((Collection)p.getReferrers(), Relation.class)) {
                String role = (String)relations.get(r);
                for (RelationMember m : r.getMembers()) {
                    if (!m.getMember().equals((Object)p)) continue;
                    String newRole = m.getRole();
                    if (newRole != null && role == null) {
                        role = newRole;
                        continue;
                    }
                    if (!(newRole != null ? !newRole.equals(role) : role != null)) continue;
                    role = "";
                    break;
                }
                relations.put(r, role);
            }
        }
        ArrayList<ChangeMembersCommand> commands = new ArrayList<ChangeMembersCommand>();
        for (Map.Entry entry : relations.entrySet()) {
            Relation rel = (Relation)entry.getKey();
            ArrayList<RelationMember> members = new ArrayList<RelationMember>(rel.getMembers());
            boolean changed = false;
            for (OsmPrimitive p : selection) {
                if (rel.getMemberPrimitives().contains(p) || rel.equals((Object)p)) continue;
                String role = (String)entry.getValue();
                if (rel.hasTag("type", "associatedStreet")) {
                    if (p.hasKey("highway")) {
                        role = "street";
                    } else if (p.hasKey("addr:housenumber")) {
                        role = "house";
                    }
                }
                members.add(new RelationMember(role, p));
                changed = true;
            }
            if (!changed) continue;
            commands.add(new ChangeMembersCommand(rel, members));
        }
        if (!commands.isEmpty()) {
            UndoRedoHandler.getInstance().add((Command)new SequenceCommand(TITLE, commands));
        }
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        try {
            this.setEnabled(selection != null && !selection.isEmpty() && ClipboardUtils.getClipboard().isDataFlavorAvailable(PrimitiveTransferData.DATA_FLAVOR));
        }
        catch (IllegalStateException e) {
            Logging.warn((Throwable)e);
        }
        catch (NullPointerException e) {
            Logging.error((Throwable)e);
        }
    }
}

