/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.imagery.OffsetBookmark;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.layer.imagery.TileSourceDisplaySettings;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetTools;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Destroyable;

public final class ImageryOffsetWatcher
implements NavigatableComponent.ZoomChangeListener,
LayerManager.LayerChangeListener,
MainLayerManager.ActiveLayerChangeListener,
Destroyable {
    private static final double THRESHOLD = 1.0E-8;
    private static ImageryOffsetWatcher instance;
    private Map<Integer, ImageryLayerData> layers = new TreeMap<Integer, ImageryLayerData>();
    private List<OffsetStateListener> listeners = new ArrayList<OffsetStateListener>();
    private Timer time;
    private double maxDistance = Config.getPref().getDouble("iodb.offset.radius", 15.0);
    private boolean offsetGood = true;

    private ImageryOffsetWatcher() {
        MapView.addZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        MainApplication.getLayerManager().addLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().addActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.checkOffset();
        this.time = new Timer();
        this.time.schedule((TimerTask)new IntervalOffsetChecker(), 0L, 2000L);
    }

    public void destroy() {
        MapView.removeZoomChangeListener((NavigatableComponent.ZoomChangeListener)this);
        MainApplication.getLayerManager().removeLayerChangeListener((LayerManager.LayerChangeListener)this);
        MainApplication.getLayerManager().removeActiveLayerChangeListener((MainLayerManager.ActiveLayerChangeListener)this);
        this.time.cancel();
    }

    public static ImageryOffsetWatcher getInstance() {
        if (instance == null) {
            instance = new ImageryOffsetWatcher();
        }
        return instance;
    }

    public void register(OffsetStateListener listener) {
        this.listeners.add(listener);
        listener.offsetStateChanged(this.offsetGood);
    }

    public void unregister(OffsetStateListener listener) {
        this.listeners.remove(listener);
    }

    private void setOffsetGood(boolean good) {
        if (good != this.offsetGood) {
            for (OffsetStateListener listener : this.listeners) {
                listener.offsetStateChanged(good);
            }
        }
        this.offsetGood = good;
    }

    private synchronized void checkOffset() {
        if (this.maxDistance <= 0.0) {
            this.setOffsetGood(true);
            return;
        }
        AbstractTileSourceLayer<?> layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer == null) {
            this.setOffsetGood(true);
            return;
        }
        TileSourceDisplaySettings displaySettings = layer.getDisplaySettings();
        LatLon center = ImageryOffsetTools.getMapCenter();
        Integer hash = layer.hashCode();
        ImageryLayerData data = this.layers.get(hash);
        if (data == null) {
            data = new ImageryLayerData();
            data.lastDx = displaySettings.getDx();
            data.lastDy = displaySettings.getDy();
            boolean r = false;
            if (Math.abs(data.lastDx) + Math.abs(data.lastDy) > 1.0E-8) {
                data.lastChecked = center;
                r = true;
            }
            this.layers.put(hash, data);
            this.setOffsetGood(r);
        } else if (Math.abs(data.lastDx - displaySettings.getDx()) + Math.abs(data.lastDy - displaySettings.getDy()) > 1.0E-8) {
            data.lastDx = displaySettings.getDx();
            data.lastDy = displaySettings.getDy();
            data.lastChecked = center;
            this.storeLayerOffset(layer);
            this.setOffsetGood(true);
        } else {
            this.setOffsetGood(data.lastChecked != null && center.greatCircleDistance((ILatLon)data.lastChecked) <= this.maxDistance * 1000.0);
        }
    }

    public void markGood() {
        AbstractTileSourceLayer<?> layer = ImageryOffsetTools.getTopImageryLayer();
        if (layer != null) {
            TileSourceDisplaySettings displaySettings = layer.getDisplaySettings();
            LatLon center = ImageryOffsetTools.getMapCenter();
            Integer hash = layer.hashCode();
            ImageryLayerData data = this.layers.get(hash);
            if (data == null) {
                data = new ImageryLayerData();
                data.lastDx = displaySettings.getDx();
                data.lastDy = displaySettings.getDy();
                data.lastChecked = center;
                this.layers.put(hash, data);
            } else {
                data.lastDx = displaySettings.getDx();
                data.lastDy = displaySettings.getDy();
                data.lastChecked = center;
            }
            this.storeLayerOffset(layer);
        }
        this.setOffsetGood(true);
    }

    public void zoomChanged() {
        this.checkOffset();
    }

    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        this.checkOffset();
    }

    public void layerAdded(LayerManager.LayerAddEvent e) {
        Layer newLayer = e.getAddedLayer();
        if (newLayer instanceof AbstractTileSourceLayer) {
            this.loadLayerOffset((AbstractTileSourceLayer)newLayer);
        }
        this.checkOffset();
    }

    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.checkOffset();
    }

    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    private void storeLayerOffset(AbstractTileSourceLayer<?> layer) {
        String id = ImageryOffsetTools.getImageryID(layer);
        if (!Config.getPref().getBoolean("iodb.remember.offsets", true) || id == null) {
            return;
        }
        LinkedList<CallSite> offsets = new LinkedList<CallSite>(Config.getPref().getList("iodb.stored.offsets"));
        Iterator iter = offsets.iterator();
        while (iter.hasNext()) {
            String[] offset = ((String)iter.next()).split(":");
            if (offset.length != 5 || !offset[0].equals(id)) continue;
            iter.remove();
        }
        LatLon center = ImageryOffsetTools.getMapCenter();
        offsets.add((CallSite)((Object)(id + ":" + center.lat() + ":" + center.lon() + ":" + layer.getDisplaySettings().getDx() + ":" + layer.getDisplaySettings().getDy())));
        Config.getPref().putList("iodb.stored.offsets", offsets);
    }

    private void loadLayerOffset(AbstractTileSourceLayer<?> layer) {
        String id = ImageryOffsetTools.getImageryID(layer);
        if (!Config.getPref().getBoolean("iodb.remember.offsets", true) || id == null) {
            return;
        }
        List offsets = Config.getPref().getList("iodb.stored.offsets");
        for (String offset : offsets) {
            String[] parts = offset.split(":");
            if (parts.length != 5 || !parts[0].equals(id)) continue;
            double[] dparts = new double[4];
            try {
                for (int i = 0; i < 4; ++i) {
                    dparts[i] = Double.parseDouble(parts[i + 1]);
                }
            }
            catch (NumberFormatException e) {
                continue;
            }
            LatLon lastPos = new LatLon(dparts[0], dparts[1]);
            if (!(lastPos.greatCircleDistance((ILatLon)ImageryOffsetTools.getMapCenter()) < Math.max(this.maxDistance, 3.0) * 1000.0)) continue;
            OffsetBookmark bookmark = new OffsetBookmark(ProjectionRegistry.getProjection().toCode(), null, layer.getName(), "Restored", dparts[2], dparts[3]);
            layer.getDisplaySettings().setOffsetBookmark(bookmark);
            return;
        }
    }

    public static interface OffsetStateListener {
        public void offsetStateChanged(boolean var1);
    }

    private class IntervalOffsetChecker
    extends TimerTask {
        private IntervalOffsetChecker() {
        }

        @Override
        public void run() {
            ImageryOffsetWatcher.this.maxDistance = Config.getPref().getDouble("iodb.offset.radius", 15.0);
            ImageryOffsetWatcher.this.checkOffset();
        }
    }

    private static class ImageryLayerData {
        public double lastDx = 0.0;
        public double lastDy = 0.0;
        public LatLon lastChecked;

        private ImageryLayerData() {
        }
    }
}

