/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.imagery_offset_db;

import java.util.Map;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.plugins.imagery_offset_db.ImageryOffsetBase;

public class CalibrationObject
extends ImageryOffsetBase {
    private LatLon[] geometry;

    public CalibrationObject(LatLon[] geometry) {
        this.geometry = geometry;
    }

    public CalibrationObject(OsmPrimitive p) {
        if (p instanceof Node) {
            this.geometry = new LatLon[]{((Node)p).getCoor()};
        } else if (p instanceof Way) {
            this.geometry = new LatLon[((Way)p).getNodesCount()];
            for (int i = 0; i < this.geometry.length; ++i) {
                this.geometry[i] = ((Way)p).getNode(i).getCoor();
            }
        } else {
            throw new IllegalArgumentException("Calibration Object can be created either from node or a way");
        }
    }

    public LatLon[] getGeometry() {
        return this.geometry;
    }

    @Override
    public void putServerParams(Map<String, String> map) {
        super.putServerParams(map);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.geometry.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.geometry[i].lon()).append(' ').append(this.geometry[i].lat());
        }
        map.put("geometry", sb.toString());
    }

    @Override
    public String toString() {
        return "CalibrationObject{" + this.geometry.length + "nodes; position=" + this.position + ", date=" + this.date + ", author=" + this.author + ", description=" + this.description + ", abandonDate=" + this.abandonDate + "}";
    }
}

