/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.seamapeditor.panels;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EnumMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.plugins.seamapeditor.SmedAction;
import org.openstreetmap.josm.plugins.seamapeditor.messages.Messages;
import org.openstreetmap.josm.plugins.seamapeditor.seamarks.SeaMark;
import org.openstreetmap.josm.tools.I18n;

public class PanelCol
extends JPanel {
    private SmedAction dlg;
    private SeaMark.Ent ent;
    private ButtonGroup colourButtons = new ButtonGroup();
    public JRadioButton delButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/DelButton.png")));
    public JRadioButton addButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/AddButton.png")));
    public JRadioButton whiteButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/WhiteButton.png")));
    public JRadioButton redButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/RedButton.png")));
    public JRadioButton greenButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/GreenButton.png")));
    public JRadioButton yellowButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/YellowButton.png")));
    public JRadioButton orangeButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/OrangeButton.png")));
    public JRadioButton amberButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/AmberButton.png")));
    public JRadioButton blueButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BlueButton.png")));
    public JRadioButton violetButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/VioletButton.png")));
    public JRadioButton blackButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BlackButton.png")));
    public JRadioButton greyButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/GreyButton.png")));
    public JRadioButton brownButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/BrownButton.png")));
    public JRadioButton magentaButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/MagentaButton.png")));
    public JRadioButton pinkButton = new JRadioButton(new ImageIcon(this.getClass().getResource("/images/PinkButton.png")));
    public EnumMap<SeaMark.Col, JRadioButton> colours = new EnumMap(SeaMark.Col.class);
    private ActionListener alColour = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SeaMark.Col col : PanelCol.this.colours.keySet()) {
                JRadioButton button;
                block14: {
                    block16: {
                        block17: {
                            block18: {
                                block15: {
                                    button = PanelCol.this.colours.get((Object)col);
                                    if (!button.isSelected()) break block14;
                                    if (PanelCol.this.ent == SeaMark.Ent.LIGHT) {
                                        if (((String)SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.CHR, 0)).contains("Al")) {
                                            if (button == PanelCol.this.delButton && SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.ALT, 0) == SeaMark.Col.UNKCOL || SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0) == SeaMark.Col.UNKCOL) {
                                                SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.COL, 0, (Object)col);
                                                SmedAction.panelMain.panelLit.panelChr.col1Label.setBackground(SeaMark.ColMAP.get((Object)col));
                                            } else {
                                                SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.ALT, 0, (Object)col);
                                                SmedAction.panelMain.panelLit.panelChr.col2Label.setBackground(SeaMark.ColMAP.get((Object)col));
                                            }
                                        } else {
                                            SmedAction.panelMain.mark.setLightAtt(SeaMark.Att.COL, 0, (Object)col);
                                            SmedAction.panelMain.panelLit.panelChr.col1Label.setBackground(SeaMark.ColMAP.get((Object)col));
                                            SmedAction.panelMain.panelLit.panelChr.col2Label.setBackground(SeaMark.ColMAP.get((Object)col));
                                        }
                                        button.setBorderPainted(true);
                                        continue;
                                    }
                                    if (button != PanelCol.this.delButton) break block15;
                                    SmedAction.panelMain.mark.subColour(PanelCol.this.ent, PanelCol.this.stackIdx);
                                    break block16;
                                }
                                if (button != PanelCol.this.addButton) break block17;
                                if (PanelCol.this.stackCol.size() != 0) {
                                    ++PanelCol.this.stackIdx;
                                }
                                if (PanelCol.this.stackCol.size() != 0) break block18;
                                SmedAction.panelMain.mark.setColour(PanelCol.this.ent, col);
                                break block16;
                            }
                            switch (SmedAction.panelMain.mark.getPattern(PanelCol.this.ent)) {
                                case NOPAT: {
                                    break;
                                }
                                case BORDER: 
                                case CROSS: {
                                    if (PanelCol.this.stackCol.size() < 2) {
                                        SmedAction.panelMain.mark.addColour(PanelCol.this.ent, PanelCol.this.stackIdx, col);
                                        break;
                                    }
                                    break block16;
                                }
                                case SQUARED: {
                                    if (PanelCol.this.stackCol.size() < 4) {
                                        SmedAction.panelMain.mark.addColour(PanelCol.this.ent, PanelCol.this.stackIdx, col);
                                        break;
                                    }
                                    break block16;
                                }
                                default: {
                                    SmedAction.panelMain.mark.addColour(PanelCol.this.ent, PanelCol.this.stackIdx, col);
                                    break;
                                }
                            }
                            break block16;
                        }
                        SmedAction.panelMain.mark.setColour(PanelCol.this.ent, PanelCol.this.stackIdx, col);
                    }
                    PanelCol.this.syncPanel();
                    continue;
                }
                button.setBorderPainted(false);
            }
        }
    };
    private JPanel stack;
    private ButtonGroup stackColours = new ButtonGroup();
    private ArrayList<JRadioButton> stackCol = new ArrayList();
    private int stackIdx = 0;
    private ActionListener alStack = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; PanelCol.this.stackCol.size() > i; ++i) {
                JRadioButton button = PanelCol.this.stackCol.get(i);
                if (button.isSelected()) {
                    PanelCol.this.stackIdx = i;
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
        }
    };

    public PanelCol(SmedAction dia, SeaMark.Ent entity) {
        this.dlg = dia;
        this.ent = entity;
        this.setLayout(null);
        this.add(this.getColButton(this.delButton, 0, 0, 34, 16, Messages.getString("RemColour"), SeaMark.Col.UNKCOL));
        this.add(this.getColButton(this.whiteButton, 0, 16, 34, 16, Messages.getString("White"), SeaMark.Col.WHITE));
        this.add(this.getColButton(this.redButton, 0, 32, 34, 16, Messages.getString("Red"), SeaMark.Col.RED));
        this.add(this.getColButton(this.orangeButton, 0, 48, 34, 16, Messages.getString("Orange"), SeaMark.Col.ORANGE));
        this.add(this.getColButton(this.amberButton, 0, 64, 34, 16, Messages.getString("Amber"), SeaMark.Col.AMBER));
        this.add(this.getColButton(this.yellowButton, 0, 80, 34, 16, Messages.getString("Yellow"), SeaMark.Col.YELLOW));
        this.add(this.getColButton(this.greenButton, 0, 96, 34, 16, Messages.getString("Green"), SeaMark.Col.GREEN));
        this.add(this.getColButton(this.blueButton, 0, 112, 34, 16, Messages.getString("Blue"), SeaMark.Col.BLUE));
        this.add(this.getColButton(this.violetButton, 0, 128, 34, 16, Messages.getString("Violet"), SeaMark.Col.VIOLET));
        if (this.ent != SeaMark.Ent.LIGHT) {
            this.add(this.getColButton(this.addButton, 0, 144, 34, 16, Messages.getString("AddColour"), SeaMark.Col.BLANK));
            this.add(this.getColButton(this.blackButton, 37, 0, 34, 16, Messages.getString("Black"), SeaMark.Col.BLACK));
            this.add(this.getColButton(this.greyButton, 37, 16, 34, 16, Messages.getString("Grey"), SeaMark.Col.GREY));
            this.add(this.getColButton(this.brownButton, 37, 32, 34, 16, Messages.getString("Brown"), SeaMark.Col.BROWN));
            this.add(this.getColButton(this.magentaButton, 37, 48, 34, 16, Messages.getString("Magenta"), SeaMark.Col.MAGENTA));
            this.add(this.getColButton(this.pinkButton, 37, 64, 34, 16, Messages.getString("Pink"), SeaMark.Col.PINK));
            this.stack = new JPanel();
            this.stack.setBorder(BorderFactory.createLineBorder(Color.black, 2));
            this.stack.setBounds(38, 87, 34, 64);
            this.stack.setLayout(null);
            this.add(this.stack);
        }
    }

    public void trimStack(int max) {
        while (this.stackCol.size() > max) {
            this.stackCol.get(this.stackCol.size() - 1).setSelected(true);
            this.delButton.doClick();
        }
    }

    public void syncPanel() {
        if (this.ent == SeaMark.Ent.LIGHT) {
            for (SeaMark.Col col : this.colours.keySet()) {
                JRadioButton button = this.colours.get((Object)col);
                if (SmedAction.panelMain.mark.getLightAtt(SeaMark.Att.COL, 0) == col) {
                    button.setBorderPainted(true);
                    continue;
                }
                button.setBorderPainted(false);
            }
        } else {
            JRadioButton btnI;
            int idx = 0;
            while (SmedAction.panelMain.mark.getColour(this.ent, idx) != SeaMark.Col.UNKCOL) {
                if (this.stackCol.size() <= idx) {
                    this.stackCol.add(idx, new JRadioButton(new ImageIcon(this.getClass().getResource("/images/ColourButton.png"))));
                    btnI = this.stackCol.get(idx);
                    btnI.setBorder(BorderFactory.createLoweredBevelBorder());
                    this.stack.add(btnI);
                    this.stackColours.add(btnI);
                    btnI.addActionListener(this.alStack);
                }
                ++idx;
            }
            while (idx < this.stackCol.size()) {
                btnI = this.stackCol.get(idx);
                btnI.removeActionListener(this.alStack);
                this.stackColours.remove(btnI);
                this.stack.remove(btnI);
                this.stackCol.remove(idx);
            }
            if (this.stackIdx >= this.stackCol.size()) {
                this.stackIdx = this.stackCol.size() - 1;
            }
            if (this.stackIdx < 0) {
                this.stackIdx = 0;
            }
            if (this.stackCol.size() == 0) {
                this.stack.repaint();
            } else {
                int height = 60 / this.stackCol.size();
                for (idx = 0; this.stackCol.size() > idx; ++idx) {
                    JRadioButton btnI2 = this.stackCol.get(idx);
                    btnI2.setBounds(2, 2 + idx * height, 30, height);
                    btnI2.setBackground(SeaMark.ColMAP.get((Object)SmedAction.panelMain.mark.getColour(this.ent, idx)));
                    if (this.stackIdx == idx) {
                        btnI2.setBorderPainted(true);
                        continue;
                    }
                    btnI2.setBorderPainted(false);
                }
            }
        }
    }

    private JRadioButton getColButton(JRadioButton button, int x, int y, int w, int h, String tip, SeaMark.Col col) {
        button.setBounds(new Rectangle(x, y, w, h));
        button.setBorder(BorderFactory.createLoweredBevelBorder());
        button.setToolTipText(I18n.tr((String)tip, (Object[])new Object[0]));
        button.addActionListener(this.alColour);
        this.colourButtons.add(button);
        this.colours.put(col, button);
        return button;
    }
}

