/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.StructUtils;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignInputDialog;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignsReader;
import org.openstreetmap.josm.plugins.roadsigns.Sign;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.spi.preferences.IPreferences;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.xml.sax.SAXException;

public class RoadSignsPlugin
extends Plugin {
    private static final String SELECTION_PREFERENCE = "plugin.roadsigns.preset.selection";
    private static final String SOURCES_PREFERENCE = "plugin.roadsigns.sources";
    private static final String LAST_SOURCES_PREFERENCE = "plugin.roadsigns.sources.last";
    private static final String CUSTOM = I18n.marktr((String)"custom");
    static PresetMetaData selectedPreset;
    static List<Sign> signs;
    static List<String> iconDirs;
    private static RoadSignsPlugin plugin;
    private static final PresetMetaData PRESET_AT;
    private static final PresetMetaData PRESET_BE;
    private static final PresetMetaData PRESET_CZ;
    private static final PresetMetaData PRESET_ES;
    private static final PresetMetaData PRESET_DE;
    private static final PresetMetaData PRESET_PL;
    private static final PresetMetaData PRESET_SK;
    private static final Collection<PresetMetaData> DEFAULT_PRESETS;

    private static void setPluginInstance(RoadSignsPlugin plugin) {
        RoadSignsPlugin.plugin = plugin;
    }

    public RoadSignsPlugin(PluginInformation info) {
        super(info);
        RoadSignsPlugin.setPluginInstance(this);
        RoadSignsPlugin.registerAction();
    }

    static File pluginDir() {
        File dir = plugin.getPluginDirs().getUserDataDirectory(false);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new UncheckedIOException(new IOException("Could not create directory: " + dir.getAbsolutePath()));
        }
        return dir;
    }

    private static void registerAction() {
        JButton btn = new JButton((Action)((Object)new RoadSignAction()));
        btn.setText(null);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setPreferredSize(new Dimension(18, 18));
        PropertiesDialog.pluginHook.add(btn);
        PropertiesDialog.pluginHook.setLayout(new FlowLayout(1, 0, 0));
        PropertiesDialog.pluginHook.revalidate();
    }

    public static void setSelectedPreset(PresetMetaData preset) throws IOException {
        Config.getPref().put(SELECTION_PREFERENCE, preset.code);
        RoadSignsPlugin.loadSignPreset();
    }

    public static List<PresetMetaData> getAvailablePresetsMetaData() {
        List customFiles;
        List presetsData = Objects.requireNonNull(StructUtils.getListOfStructs((IPreferences)Config.getPref(), (String)"plugin.roadsigns.presets", DEFAULT_PRESETS, PresetMetaData.class));
        String customFile = Config.getPref().get(SOURCES_PREFERENCE, null);
        if (customFile == null && (customFiles = Config.getPref().getList(SOURCES_PREFERENCE, null)) != null && !customFiles.isEmpty()) {
            customFile = (String)customFiles.iterator().next();
        }
        if (customFile != null) {
            presetsData.add(RoadSignsPlugin.readCustomFile(customFile));
        } else {
            Config.getPref().put(LAST_SOURCES_PREFERENCE, null);
        }
        return presetsData;
    }

    private static PresetMetaData readCustomFile(String customFile) {
        String lastCustomFile = Config.getPref().get(LAST_SOURCES_PREFERENCE, null);
        if (!Objects.equals(customFile, lastCustomFile)) {
            Config.getPref().put(LAST_SOURCES_PREFERENCE, customFile);
            Config.getPref().put(SELECTION_PREFERENCE, CUSTOM);
        }
        String customIconDirsStr = Config.getPref().get("plugin.roadsigns.icon.sources", null);
        ArrayList<String> customIconDirs = null;
        customIconDirs = customIconDirsStr != null ? new ArrayList<String>(Arrays.asList(customIconDirsStr.split(","))) : Config.getPref().getList("plugin.roadsigns.icon.sources", null);
        customIconDirs = customIconDirs != null ? new ArrayList<String>(customIconDirs) : new ArrayList();
        if (!customFile.startsWith("resource:")) {
            String parentDir;
            try {
                parentDir = new URI(customFile).getPath();
            }
            catch (URISyntaxException ex) {
                Logging.trace((Throwable)ex);
                File f = new File(customFile);
                parentDir = f.getParent();
            }
            if (parentDir != null && !parentDir.isEmpty()) {
                customIconDirs.add(parentDir);
            }
        }
        if (Config.getPref().getBoolean("plugin.roadsigns.use_default_icon_source", true)) {
            customIconDirs.add("resource://images/");
        }
        return new PresetMetaData(CUSTOM, I18n.tr((String)CUSTOM, (Object[])new Object[0]), customFile, String.join((CharSequence)",", customIconDirs));
    }

    protected static void loadSignPreset() throws IOException {
        List<PresetMetaData> presetsData = RoadSignsPlugin.getAvailablePresetsMetaData();
        String code = Config.getPref().get(SELECTION_PREFERENCE, null);
        for (PresetMetaData data : presetsData) {
            if (!data.code.equals(code)) continue;
            selectedPreset = data;
            break;
        }
        if (selectedPreset == null) {
            selectedPreset = !presetsData.isEmpty() ? presetsData.get(0) : PRESET_DE;
        }
        iconDirs = Arrays.asList(RoadSignsPlugin.selectedPreset.icon_path.split(","));
        String source = RoadSignsPlugin.selectedPreset.preset_path;
        try (CachedFile cachedFile = new CachedFile(source);
             InputStream in = cachedFile.getInputStream();){
            RoadSignsReader reader = new RoadSignsReader(in);
            signs = reader.parse();
        }
        catch (IOException ex) {
            Logging.error((Throwable)ex);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Could not read tagging preset source: ''{0}''", (Object[])new Object[]{source}), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            throw ex;
        }
        catch (SAXException ex) {
            Logging.error((Throwable)ex);
            JOptionPane.showMessageDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Error parsing tagging preset from ''{0}'':\n", (Object[])new Object[]{source}) + ex.getMessage(), I18n.tr((String)"Error", (Object[])new Object[0]), 0);
            throw new IOException(ex);
        }
    }

    static {
        PRESET_AT = new PresetMetaData("AT", I18n.tr((String)"Austria", (Object[])new Object[0]), "resource://data/roadsignpresetAT.xml", "resource://images/AT/");
        PRESET_BE = new PresetMetaData("BE", I18n.tr((String)"Belgium", (Object[])new Object[0]), "resource://data/roadsignpresetBE.xml", "resource://images/BE/");
        PRESET_CZ = new PresetMetaData("CZ", I18n.tr((String)"Czech Republic", (Object[])new Object[0]), "resource://data/roadsignpresetCZ.xml", "resource://images/CZ/");
        PRESET_ES = new PresetMetaData("ES", I18n.tr((String)"Spain", (Object[])new Object[0]), "resource://data/roadsignpresetES.xml", "resource://images/ES/");
        PRESET_DE = new PresetMetaData("DE", I18n.tr((String)"Germany", (Object[])new Object[0]), "resource://data/roadsignpresetDE.xml", "resource://images/DE/");
        PRESET_PL = new PresetMetaData("PL", I18n.tr((String)"Poland", (Object[])new Object[0]), "resource://data/roadsignpresetPL.xml", "resource://images/PL/");
        PRESET_SK = new PresetMetaData("SK", I18n.tr((String)"Slovakia", (Object[])new Object[0]), "resource://data/roadsignpresetSK.xml", "resource://images/SK/");
        DEFAULT_PRESETS = Arrays.asList(PRESET_AT, PRESET_BE, PRESET_CZ, PRESET_ES, PRESET_DE, PRESET_PL, PRESET_SK);
    }

    public static class PresetMetaData {
        @StructUtils.StructEntry
        public String code;
        @StructUtils.StructEntry
        public String display_name;
        @StructUtils.StructEntry
        public String preset_path;
        @StructUtils.StructEntry
        public String icon_path;

        public PresetMetaData() {
        }

        public PresetMetaData(String countryCode, String displayName, String presetPath, String iconsPath) {
            this.code = countryCode;
            this.display_name = displayName;
            this.preset_path = presetPath;
            this.icon_path = iconsPath;
        }

        public String toString() {
            return this.display_name;
        }
    }

    private static class RoadSignAction
    extends JosmAction {
        RoadSignAction() {
            super(I18n.tr((String)"Roadsign tagging", (Object[])new Object[0]), "pref/roadsigns-small", I18n.tr((String)"Add tags by clicking on road signs", (Object[])new Object[0]), Shortcut.registerShortcut((String)"plugin:roadsigns:dialog", (String)I18n.tr((String)"Roadsigns plugin: open dialog", (Object[])new Object[0]), (int)81, (int)5007), false);
        }

        public void actionPerformed(ActionEvent e) {
            String code = Config.getPref().get(RoadSignsPlugin.SELECTION_PREFERENCE, null);
            if (code == null) {
                ExtendedDialog ed = new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Settings", (Object[])new Object[0]), new String[]{I18n.tr((String)"Ok", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])});
                ed.setButtonIcons(new String[]{"ok", "cancel"});
                RoadSignInputDialog.SettingsPanel settings = new RoadSignInputDialog.SettingsPanel(true, null);
                ed.setContent((Component)settings);
                ed.showDialog();
                if (ed.getValue() != 1) {
                    return;
                }
                try {
                    settings.apply();
                }
                catch (IOException ex) {
                    Logging.trace((Throwable)ex);
                    return;
                }
            }
            try {
                RoadSignsPlugin.loadSignPreset();
            }
            catch (IOException ex) {
                Logging.trace((Throwable)ex);
                return;
            }
            RoadSignInputDialog input = new RoadSignInputDialog();
            input.showDialog();
        }
    }
}

