/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipReader;
import org.openstreetmap.josm.tools.I18n;

public class ZipImporter
extends AbstractImporter {
    public static final ExtensionFileFilter ZIP_FILE_FILTER = new ExtensionFileFilter("zip", "zip", I18n.tr((String)"Zip Files", (Object[])new Object[0]) + " (*.zip)");

    public ZipImporter() {
        super(ZIP_FILE_FILTER);
    }

    protected DataSet parseDataSet(InputStream in, ProgressMonitor instance) throws IllegalDataException {
        try {
            return ZipReader.parseDataSet(in, this.handler, instance, true);
        }
        catch (IOException | FactoryConfigurationError | XMLStreamException e) {
            throw new IllegalDataException(e);
        }
    }

    public boolean acceptFile(File pathname) {
        return super.acceptFile(pathname) && !pathname.getName().endsWith(".osm.zip");
    }
}

