/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.io.IllegalDataException;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.gui.DialogPrompter;
import org.openstreetmap.josm.plugins.opendata.core.io.NeptuneReader;
import org.openstreetmap.josm.plugins.opendata.core.io.NetworkReader;
import org.openstreetmap.josm.plugins.opendata.core.io.XmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ArchiveHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.CandidateChooser;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;
import org.openstreetmap.josm.plugins.opendata.core.util.OdUtils;
import org.openstreetmap.josm.tools.Logging;

public abstract class ArchiveReader
extends AbstractReader {
    protected final AbstractDataSetHandler handler;
    protected final ArchiveHandler archiveHandler;
    protected final boolean promptUser;
    private File file;

    protected ArchiveReader(AbstractDataSetHandler handler, ArchiveHandler archiveHandler, boolean promptUser) {
        this.handler = handler;
        this.archiveHandler = archiveHandler;
        this.promptUser = promptUser;
    }

    public final File getReadFile() {
        return this.file;
    }

    protected abstract void extractArchive(File var1, List<File> var2) throws IOException, FileNotFoundException;

    protected abstract String getTaskMessage();

    protected Collection<File> getDocsToParse(File temp, final ProgressMonitor progressMonitor) throws FileNotFoundException, IOException {
        final ArrayList<File> candidates = new ArrayList<File>();
        if (progressMonitor != null) {
            progressMonitor.beginTask(this.getTaskMessage());
        }
        this.extractArchive(temp, candidates);
        if (this.promptUser && candidates.size() > 1) {
            DialogPrompter<CandidateChooser> prompt = new DialogPrompter<CandidateChooser>(this){
                final /* synthetic */ ArchiveReader this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                protected CandidateChooser buildDialog() {
                    return new CandidateChooser(progressMonitor.getWindowParent(), candidates);
                }
            };
            if (prompt.promptInEdt().getValue() == 1) {
                return Collections.singleton(((CandidateChooser)((Object)prompt.getDialog())).getSelectedFile());
            }
        } else if (!candidates.isEmpty()) {
            return candidates;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<File, DataSet> parseDocs(ProgressMonitor progressMonitor) throws IOException, XMLStreamException, FactoryConfigurationError, IllegalDataException {
        HashMap<File, DataSet> result = new HashMap<File, DataSet>();
        File temp = OdUtils.createTempDir();
        try {
            this.file = null;
            for (File f : this.getDocsToParse(temp, progressMonitor)) {
                DataSet from = this.getDataForFile(f, progressMonitor);
                if (from == null) continue;
                result.put(f, from);
            }
        }
        finally {
            OdUtils.deleteDir(temp);
            if (progressMonitor != null) {
                progressMonitor.finishTask();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet parseDoc(ProgressMonitor progressMonitor) throws IOException, XMLStreamException, FactoryConfigurationError, IllegalDataException {
        File temp = OdUtils.createTempDir();
        try {
            DataSet from;
            this.file = null;
            Collection<File> files = this.getDocsToParse(temp, progressMonitor);
            if (!files.isEmpty()) {
                this.file = files.iterator().next();
            }
            if ((from = this.getDataForFile(this.file, progressMonitor)) != null) {
                this.ds = from;
            }
        }
        catch (IllegalArgumentException e) {
            Logging.error((Throwable)e);
        }
        finally {
            OdUtils.deleteDir(temp);
            if (progressMonitor != null) {
                progressMonitor.finishTask();
            }
        }
        return this.ds;
    }

    protected DataSet doParseDataSet(InputStream source, ProgressMonitor progressMonitor) throws IllegalDataException {
        return null;
    }

    protected DataSet getDataForFile(File f, ProgressMonitor progressMonitor) throws FileNotFoundException, IOException, XMLStreamException, FactoryConfigurationError, IllegalDataException {
        if (f == null) {
            return null;
        }
        if (!f.exists()) {
            Logging.warn((String)("File does not exist: " + f.getPath()));
            return null;
        }
        Logging.info((String)("Parsing file " + f.getName()));
        DataSet from = null;
        try (FileInputStream in = new FileInputStream(f);){
            String lowerCaseName;
            ProgressMonitor instance = null;
            if (progressMonitor != null) {
                instance = progressMonitor.createSubTaskMonitor(-1, false);
            }
            if ((lowerCaseName = f.getName().toLowerCase(Locale.ROOT)).endsWith("csv")) {
                from = CsvReader.parseDataSet(in, this.handler, instance);
            } else if (lowerCaseName.endsWith("kml")) {
                from = KmlReader.parseDataSet(in, instance);
            } else if (lowerCaseName.endsWith("kmz")) {
                from = KmzReader.parseDataSet(in, instance);
            } else if (lowerCaseName.endsWith("xls")) {
                from = XlsReader.parseDataSet(in, this.handler, instance);
            } else if (lowerCaseName.endsWith("ods")) {
                from = OdsReader.parseDataSet(in, this.handler, instance);
            } else if (lowerCaseName.endsWith("shp")) {
                from = ShpReader.parseDataSet(in, f, this.handler, instance);
            } else if (lowerCaseName.endsWith("mif")) {
                from = MifReader.parseDataSet(in, f, this.handler);
            } else if (lowerCaseName.endsWith("tab")) {
                from = TabReader.parseDataSet(in, f, this.handler, instance);
            } else if (lowerCaseName.endsWith("gml")) {
                from = GmlReader.parseDataSet(in, this.handler, instance);
            } else if (lowerCaseName.endsWith("xml")) {
                if (OdPlugin.getInstance().xmlImporter.acceptFile(f)) {
                    from = NeptuneReader.parseDataSet(in, this.handler, instance);
                } else {
                    Logging.warn((String)("Unsupported XML file: " + f.getName()));
                }
            } else {
                Logging.warn((String)("Unsupported file extension: " + f.getName()));
            }
            DataSet dataSet = from;
            return dataSet;
        }
    }

    protected final void lookForCandidate(String entryName, List<File> candidates, File file) {
        for (String ext : NetworkReader.FILE_READERS.keySet()) {
            if (!entryName.toLowerCase(Locale.ROOT).endsWith("." + ext)) continue;
            candidates.add(file);
            break;
        }
        if (XmlImporter.XML_FILE_FILTER.accept(file) && (this.archiveHandler != null && this.archiveHandler.skipXsdValidation() || OdPlugin.getInstance().xmlImporter.acceptFile(file))) {
            candidates.add(file);
        }
    }
}

