/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;

public class CellReference {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private final int _rowIndex;
    private final int _colIndex;
    private final String _sheetName;
    private final boolean _isRowAbs;
    private final boolean _isColAbs;

    public CellReference(int n, int n2) {
        this(n, n2, false, false);
    }

    public CellReference(int n, short s) {
        this(n, s & 0xFFFF, false, false);
    }

    public CellReference(Cell cell) {
        this(cell.getRowIndex(), cell.getColumnIndex(), false, false);
    }

    public CellReference(int n, int n2, boolean bl, boolean bl2) {
        this(null, n, n2, bl, bl2);
    }

    public CellReference(String string, int n, int n2, boolean bl, boolean bl2) {
        if (n < -1) {
            throw new IllegalArgumentException("row index may not be negative");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("column index may not be negative");
        }
        this._sheetName = string;
        this._rowIndex = n;
        this._colIndex = n2;
        this._isRowAbs = bl;
        this._isColAbs = bl2;
    }

    public int getRow() {
        return this._rowIndex;
    }

    public short getCol() {
        return (short)this._colIndex;
    }

    public boolean isRowAbsolute() {
        return this._isRowAbs;
    }

    public boolean isColAbsolute() {
        return this._isColAbs;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public static boolean cellReferenceIsWithinRange(String string, String string2, SpreadsheetVersion spreadsheetVersion) {
        if (!CellReference.isColumnWithnRange(string, spreadsheetVersion)) {
            return false;
        }
        return CellReference.isRowWithnRange(string2, spreadsheetVersion);
    }

    public static boolean isColumnWithnRange(String string, SpreadsheetVersion spreadsheetVersion) {
        String string2 = spreadsheetVersion.getLastColumnName();
        int n = string2.length();
        int n2 = string.length();
        if (n2 > n) {
            return false;
        }
        return n2 != n || string.toUpperCase().compareTo(string2) <= 0;
    }

    public static boolean isRowWithnRange(String string, SpreadsheetVersion spreadsheetVersion) {
        int n = Integer.parseInt(string);
        if (n < 0) {
            throw new IllegalStateException("Invalid rowStr '" + string + "'.");
        }
        if (n == 0) {
            return false;
        }
        return n <= spreadsheetVersion.getMaxRows();
    }

    public static String convertNumToColString(int n) {
        int n2 = n + 1;
        Object object = "";
        int n3 = n2;
        while (n3 > 0) {
            int n4 = n3 % 26;
            if (n4 == 0) {
                n4 = 26;
            }
            n3 = (n3 - n4) / 26;
            char c = (char)(n4 + 64);
            object = c + (String)object;
        }
        return object;
    }

    public String formatAsString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this._sheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this._sheetName);
            stringBuffer.append('!');
        }
        this.appendCellReference(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    void appendCellReference(StringBuffer stringBuffer) {
        if (this._isColAbs) {
            stringBuffer.append('$');
        }
        stringBuffer.append(CellReference.convertNumToColString(this._colIndex));
        if (this._isRowAbs) {
            stringBuffer.append('$');
        }
        stringBuffer.append(this._rowIndex + 1);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CellReference)) {
            return false;
        }
        CellReference cellReference = (CellReference)object;
        return this._rowIndex == cellReference._rowIndex && this._colIndex == cellReference._colIndex && this._isRowAbs == cellReference._isColAbs && this._isColAbs == cellReference._isColAbs;
    }
}

