/*
 * Decompiled with CFR 0.152.
 */
package livegps;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import livegps.DrawPoint;
import org.openstreetmap.josm.spi.preferences.Config;

public class CirclePanel
extends JPanel {
    JLabel label = new JLabel();
    double x = 0.0;

    public CirclePanel(double x) {
        this.add(this.label);
        this.x = x;
    }

    public void setOffset(double offs) {
        this.x = offs;
    }

    @Override
    protected void paintComponent(Graphics g) {
        boolean isVisible = Config.getPref().getBoolean("livegps.distance_visualisation", false);
        super.paintComponent(g);
        if (isVisible) {
            Graphics2D g2 = (Graphics2D)g;
            int w = this.getWidth();
            int h = this.getHeight();
            double width = 0.0;
            width = w > h ? (double)h * 0.9 : (double)w * 0.9;
            double y_start = (double)h / 2.0 - width / 2.0;
            double x_start = ((double)w - width) / 2.0;
            Rectangle2D.Double rect1 = new Rectangle2D.Double(x_start, y_start, width * 0.4, width);
            Rectangle2D.Double rect2 = new Rectangle2D.Double(x_start + width * 0.4, y_start, width * 0.2, width);
            Rectangle2D.Double rect3 = new Rectangle2D.Double(x_start + width * 0.6, y_start, width * 0.4, width);
            Ellipse2D.Double circle = new Ellipse2D.Double(x_start, y_start, width, width);
            Area rect1Area = new Area(rect1);
            Area rect2Area = new Area(rect2);
            Area rect3Area = new Area(rect3);
            Area circleArea1 = new Area(circle);
            Area circleArea2 = new Area(circle);
            Area circleArea3 = new Area(circle);
            circleArea1.intersect(rect1Area);
            circleArea2.intersect(rect2Area);
            circleArea3.intersect(rect3Area);
            g2.setStroke(new BasicStroke(2.0f, 0, 0));
            DrawPoint drawpoint = new DrawPoint();
            drawpoint.draw_point(this.x, g2, circleArea1, circleArea2, circleArea3, this.label, x_start, y_start, width);
            g2.draw(circleArea1);
            g2.draw(circleArea2);
            g2.draw(circleArea3);
            g2.setColor(Color.red);
            g2.drawLine((int)(x_start + width / 2.0), (int)y_start, (int)(x_start + width / 2.0), (int)(y_start + width));
        }
    }
}

