/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom.spreadsheet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Text;
import org.jdom2.util.IteratorIterable;
import org.jopendocument.dom.ODDocument;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.Row;
import org.jopendocument.dom.spreadsheet.TableCalcNode;
import org.jopendocument.util.CollectionUtils;

public class Cell<D extends ODDocument>
extends TableCalcNode<CellStyle, D> {
    private static final Pattern multiSpacePattern = Pattern.compile("[\t\r\n ]+");
    private static boolean OO_MODE = true;
    private final Row<D> row;

    public static boolean getTextValueMode() {
        return OO_MODE;
    }

    Cell(Row<D> row, Element element) {
        super(row.getODDocument(), element, CellStyle.class);
        this.row = row;
    }

    protected final Row<D> getRow() {
        return this.row;
    }

    protected final XMLVersion getNS() {
        return this.getODDocument().getVersion();
    }

    protected final Namespace getValueNS() {
        XMLVersion xMLVersion = this.getNS();
        return xMLVersion == XMLVersion.OD ? xMLVersion.getOFFICE() : xMLVersion.getTABLE();
    }

    protected final String getType() {
        return this.getElement().getAttributeValue("value-type", this.getValueNS());
    }

    public final ODValueType getValueType() {
        String string = this.getType();
        return string == null ? null : ODValueType.get(string);
    }

    @Override
    protected String getStyleName() {
        throw new UnsupportedOperationException("cannot resolve our style, use MutableCell");
    }

    private final String getValue(String string) {
        return this.getElement().getAttributeValue(string, this.getValueNS());
    }

    public Object getValue() {
        ODValueType oDValueType = this.getValueType();
        if (oDValueType == null || oDValueType == ODValueType.STRING) {
            String string;
            String string2 = string = oDValueType == null ? null : this.getValue(oDValueType.getValueAttribute());
            if (string != null) {
                return string;
            }
            return this.getTextValue();
        }
        return oDValueType.parse(this.getValue(oDValueType.getValueAttribute()));
    }

    public String getTextValue() {
        return this.getTextValue(Cell.getTextValueMode());
    }

    public String getTextValue(boolean bl) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Element element : this.getElement().getChildren()) {
            Element element2 = element;
            if (!element2.getName().equals("p") && !element2.getName().equals("h") || !element2.getNamespacePrefix().equals("text")) continue;
            arrayList.add(this.getStringValue(element2, bl));
        }
        return CollectionUtils.join(arrayList, "\n");
    }

    private String getStringValue(Element element, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Namespace namespace = element.getNamespace();
        boolean bl2 = false;
        IteratorIterable<Content> iteratorIterable = element.getDescendants();
        while (iteratorIterable.hasNext()) {
            Object object;
            Object e = iteratorIterable.next();
            if (e instanceof Text) {
                object = multiSpacePattern.matcher(((Text)e).getText()).replaceAll(" ");
                if (!bl && ((String)object).startsWith(" ") && (bl2 || stringBuilder.length() == 0)) {
                    stringBuilder.append(((String)object).substring(1));
                } else {
                    stringBuilder.append((String)object);
                }
                bl2 = ((String)object).endsWith(" ");
                continue;
            }
            if (!(e instanceof Element)) continue;
            object = (Element)e;
            if (((Element)object).getName().equals("tab") && ((Element)object).getNamespace().equals(namespace)) {
                stringBuilder.append("\t");
                continue;
            }
            if (((Element)object).getName().equals("line-break") && ((Element)object).getNamespace().equals(namespace)) {
                stringBuilder.append("\n");
                continue;
            }
            if (!((Element)object).getName().equals("s") || !((Element)object).getNamespace().equals(namespace)) continue;
            int n = Integer.valueOf(((Element)object).getAttributeValue("c", namespace, "1"));
            char[] cArray = new char[n];
            Arrays.fill(cArray, ' ');
            stringBuilder.append(cArray);
        }
        if (!bl && bl2) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

