/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.EnumSet;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODValueType;
import org.jopendocument.dom.ODXMLDocument;
import org.jopendocument.dom.XMLVersion;

public class ODUserDefinedMeta
extends ODNode {
    private static final String ELEM_NAME = "user-defined";
    private static final EnumSet<ODValueType> allowedTypes = EnumSet.of(ODValueType.FLOAT, ODValueType.DATE, ODValueType.TIME, ODValueType.BOOLEAN, ODValueType.STRING);
    private final ODXMLDocument parent;

    static ODUserDefinedMeta create(String string, ODXMLDocument oDXMLDocument) {
        Element element = new Element(ELEM_NAME, oDXMLDocument.getVersion().getMETA());
        element.setAttribute("name", string, oDXMLDocument.getVersion().getMETA());
        ODUserDefinedMeta oDUserDefinedMeta = new ODUserDefinedMeta(element, oDXMLDocument);
        oDUserDefinedMeta.setValue("");
        return oDUserDefinedMeta;
    }

    private static List<Element> getChildren(Element element, Namespace namespace) {
        return element.getChildren(ELEM_NAME, namespace);
    }

    static Element getElement(Element element, String string, XMLVersion xMLVersion) {
        Namespace namespace = xMLVersion.getMETA();
        for (Element element2 : ODUserDefinedMeta.getChildren(element, namespace)) {
            if (!string.equals(element2.getAttributeValue("name", namespace))) continue;
            return element2;
        }
        return null;
    }

    ODUserDefinedMeta(Element element, ODXMLDocument oDXMLDocument) {
        super(element);
        this.parent = oDXMLDocument;
    }

    protected final ODXMLDocument getParent() {
        return this.parent;
    }

    private final XMLVersion getNS() {
        return this.getParent().getVersion();
    }

    private final Attribute getValueTypeAttr() {
        return this.getValueTypeAttr(true);
    }

    private final Attribute getValueTypeAttr(boolean bl) {
        Attribute attribute = this.getElement().getAttribute("value-type", this.getNS().getMETA());
        if (attribute == null && bl) {
            attribute = new Attribute("value-type", ODValueType.STRING.getName(), this.getNS().getMETA());
            this.getElement().setAttribute(attribute);
        }
        return attribute;
    }

    public final void setValue(Object object) {
        this.setValue(object, ODValueType.forObject(object));
    }

    public final void setValue(Object object, ODValueType oDValueType) {
        if (!allowedTypes.contains((Object)oDValueType)) {
            throw new IllegalArgumentException(oDValueType + " is not allowed: " + allowedTypes);
        }
        if (oDValueType != ODValueType.STRING) {
            this.getValueTypeAttr().setValue(oDValueType.getName());
        } else {
            Attribute attribute = this.getValueTypeAttr(false);
            if (attribute != null) {
                attribute.detach();
            }
        }
        this.getElement().setText(oDValueType.format(object));
    }
}

