/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class VeloToulouseHandler
extends ToulouseDataSetHandler {
    public VeloToulouseHandler() {
        super("velo-toulouse", "amenity=bicycle_rental");
        this.setWikiPage("V\u00e9l\u00f4 Toulouse");
        this.setCategory(CAT_TRANSPORT);
    }

    public boolean acceptsFilename(String filename) {
        return VeloToulouseHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Velo_Toulouse"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "bicycle_rental");
            n.put("network", "V\u00e9l\u00f4Toulouse");
            n.put("operator", "JCDecaux");
            if (n.hasKey("M_en_S_16_nov_07") && n.get("M_en_S_16_nov_07").equals("O")) {
                n.put("start_date", "2007-11-16");
            }
            n.remove("M_en_S_16_nov_07");
            n.remove("Mot_Directeur");
            n.remove("No");
            n.remove("Nrivoli");
            n.remove("street");
            VeloToulouseHandler.replace((IPrimitive)n, (String)"nb_bornettes", (String)"capacity");
            VeloToulouseHandler.replace((IPrimitive)n, (String)"num_station", (String)"ref");
            VeloToulouseHandler.replace((IPrimitive)n, (String)"nom", (String)"name");
            n.put("name", WordUtils.capitalizeFully((String)n.get("name")));
            n.remove("code_insee");
            n.remove("commune");
            n.remove("color");
            if (n.hasKey("En_service") && n.get("En_service").equals("N")) {
                n.put("fixme", "Station pas en service");
            }
            n.remove("En_service");
        }
    }
}

