/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class StationsAutoPartageHandler
extends ToulouseDataSetHandler {
    public StationsAutoPartageHandler() {
        super("stations-d-auto-partage", "amenity=car_sharing");
        this.setName("Stations d'auto partage");
        this.setCategory(CAT_TRANSPORT);
        this.getCsvHandler().setCharset("ISO-8859-15");
    }

    public boolean acceptsFilename(String filename) {
        return StationsAutoPartageHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Autopartage"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "car_sharing");
            n.remove("Lib_voie");
            n.remove("mot_dir");
            n.remove("No");
            n.remove("commune");
            n.remove("code_insee");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"id_AUTO", (String)"ref:FR:ToulouseMetropole");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"nb_places", (String)"capacity");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"arrete", (String)"bylaw");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"Societe", (String)"operator");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"annee", (String)"start_date");
            n.remove("photo");
            StationsAutoPartageHandler.replace((IPrimitive)n, (String)"obervations", (String)"note");
        }
    }
}

