/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class PMRHandler
extends ToulouseDataSetHandler {
    public PMRHandler() {
        super("pmr", "amenity=parking_space");
        this.setWikiPage("PMR");
        this.setCategory(CAT_TRANSPORT);
        this.setMenuIcon("presets/vehicle/parking/handicapped.svg");
    }

    public boolean acceptsFilename(String filename) {
        return PMRHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Emplacements_PMR"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.remove("name");
            n.put("amenity", "parking_space");
            n.put("access:disabled", "designated");
            n.put("wheelchair", "designated");
            PMRHandler.replace((IPrimitive)n, (String)"nb_places", (String)"capacity:disabled");
            n.remove("Lib_voie");
            n.remove("No");
            n.remove("commune");
            n.remove("code_insee");
            n.remove("color");
            PMRHandler.replace((IPrimitive)n, (String)"id_PMR", (String)"ref:FR:ToulouseMetropole");
        }
    }
}

