/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.enfance;

import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class EcoleElementaireHandler
extends ToulouseDataSetHandler {
    public EcoleElementaireHandler() {
        super("ecoles-elementaires-publiques", "amenity=school");
        this.setWikiPage("\u00c9coles \u00e9l\u00e9mentaires publiques");
        this.setCategory(CAT_ENFANCE);
        for (String forbidden : new String[]{"maternelle", "primaire", "coll\u00e8ge", "lyc\u00e9e", "secondaire"}) {
            this.addForbiddenTag(new String[]{"school:FR=" + forbidden});
        }
    }

    public boolean acceptsFilename(String filename) {
        return EcoleElementaireHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Ecoles_Elem_Publiques"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "school");
            n.put("school:FR", "\u00e9l\u00e9mentaire");
            n.put("operator:type", "public");
            EcoleElementaireHandler.replace((IPrimitive)n, (String)"Ecole", (String)"name");
            n.put("name", WordUtils.capitalizeFully((String)n.get("name")));
            n.remove("Codpos");
            n.remove("Codsti");
            n.remove("color");
            n.remove("Index");
            n.remove("Libelle");
            n.remove("Num");
            EcoleElementaireHandler.replace((IPrimitive)n, (String)"RNE", (String)"ref:UAI");
            EcoleElementaireHandler.replace((IPrimitive)n, (String)"Tel", (String)"phone");
        }
    }
}

