/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.citoyennete;

import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class QuartiersHandler
extends ToulouseDataSetHandler {
    public QuartiersHandler() {
        super("quartiers-de-democratie-locale0", "admin_level=11");
        this.setWikiPage("Quartiers de d\u00e9mocratie locale");
        this.setCategory(CAT_CITOYENNETE);
        this.setMenuIcon("presets/misc/boundaries.svg");
    }

    public boolean acceptsFilename(String filename) {
        return QuartiersHandler.acceptsKmzTabFilename((String)filename, (String[])new String[]{"Quartiers"});
    }

    public void updateDataSet(DataSet ds) {
        for (Relation r : ds.getRelations()) {
            r.remove("name");
            QuartiersHandler.replace((IPrimitive)r, (String)"Quartier", (String)"ref");
            QuartiersHandler.replace((IPrimitive)r, (String)"Nom_Quartier", (String)"description");
            r.put("type", "boundary");
            r.put("boundary", "administrative");
            r.put("admin_level", "11");
            r.remove("Adjoint_Secteur");
            r.remove("Elu_Referent_Quartier");
            r.remove("Id");
            r.remove("Nom_Secteur");
            r.remove("Secteur");
        }
    }
}

