/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.citoyennete;

import org.apache.commons.text.WordUtils;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class Club3eAgeHandler
extends ToulouseDataSetHandler {
    public Club3eAgeHandler() {
        super("clubs-du-3eme-age", "social_facility=outreach", "social_facility:for=senior");
        this.setWikiPage("Clubs du 3\u00e8me \u00e2ge");
        this.setCategory(CAT_CITOYENNETE);
    }

    public boolean acceptsFilename(String filename) {
        return Club3eAgeHandler.acceptsCsvKmzTabFilename((String)filename, (String[])new String[]{"Club_3E_AGE"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            Club3eAgeHandler.replace((IPrimitive)n, (String)"Nom", (String)"name");
            Club3eAgeHandler.replace((IPrimitive)n, (String)"Telephone", (String)"contact:phone");
            n.put("name", WordUtils.capitalizeFully((String)n.get("name")));
            n.put("social_facility", "outreach");
            n.put("social_facility:for", "senior");
            n.remove("Adresse");
            n.remove("CP");
            n.remove("Classe");
            n.remove("CodSTI");
            n.remove("Description");
            n.remove("Numero");
            n.remove("Ville");
            n.remove("color");
        }
    }
}

