/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.education;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;

public class EtabSupHandler
extends DataGouvDataSetHandler {
    public EtabSupHandler() {
        super("Etablissements-d'enseignement-sup\u00e9rieur-30382046", wgs84);
        this.setName("\u00c9tablissements d'enseignement sup\u00e9rieur");
        this.setDownloadFileName("livraison ETALAB 28 11 2011.xls");
        this.setCsvHandler((CsvHandler)new EtabSupCsvHandler());
    }

    public boolean acceptsFilename(String filename) {
        return EtabSupHandler.acceptsXlsFilename((String)filename, (String[])new String[]{"livraison ETALAB .. .. 20..(\\.xls-fr)?"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            EtabSupHandler.replace((IPrimitive)n, (String)"NOM_ETABLISSEMENT", (String)"name");
            n.put("amenity", "university");
        }
    }

    private class EtabSupCsvHandler
    extends FrenchDataSetHandler.InternalCsvHandler {
        private EtabSupCsvHandler() {
            super((FrenchDataSetHandler)EtabSupHandler.this);
        }

        public LatLon getCoor(EastNorth en, String[] fields) {
            return wgs84.eastNorth2latlon(new EastNorth(en.north(), en.east()));
        }
    }
}

