/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.education;

import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.DefaultCsvHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;

public class Etab1er2ndDegreHandler
extends DataGouvDataSetHandler {
    public Etab1er2ndDegreHandler() {
        super("G\u00e9olocalisation-des-\u00e9tablissements-d'enseignement-du-premier-degr\u00e9-et-du-second-degr\u00e9-du-minist\u00e8re-d-30378093");
        this.setName("\u00c9tablissements d'enseignement du premier degr\u00e9 et du second degr\u00e9");
        this.setDownloadFileName("MENJVA_etab_geoloc.csv");
        this.setCsvHandler((CsvHandler)new EtabCsvHandler());
    }

    public boolean acceptsFilename(String filename) {
        return Etab1er2ndDegreHandler.acceptsCsvFilename((String)filename, (String[])new String[]{"MENJVA_etab_geoloc(\\.csv-fr)?"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "school");
            Etab1er2ndDegreHandler.replace((IPrimitive)n, (String)"numero_uai", (String)"ref:FR:UAI");
            Etab1er2ndDegreHandler.replace((IPrimitive)n, (String)"appellation_officielle_uai", (String)"name");
            Etab1er2ndDegreHandler.add((IPrimitive)n, (String)"lib_nature", (String)"school:FR", (String[])new String[]{".*MATERNELLE.*", ".*ELEMENTAIRE.*", "COLLEGE.*", "LYCEE.*"}, (String[])new String[]{"maternelle", "\u00e9l\u00e9mentaire", "college", "lyc\u00e9e"});
            n.remove("etat_etablissement");
            n.remove("nature_uai");
            n.remove("patronyme_uai");
            n.remove("sous_fic");
        }
    }

    private class EtabCsvHandler
    extends DefaultCsvHandler {
        public EtabCsvHandler() {
            this.setCharset("ISO-8859-15");
            this.setHandlesProjection(true);
        }

        public LatLon getCoor(EastNorth en, String[] fields) {
            return Etab1er2ndDegreHandler.getLatLonByDptCode((EastNorth)en, (String)fields[0].substring(0, 3), (boolean)false);
        }
    }
}

