/*
 * Decompiled with CFR 0.152.
 */
package org.jopendocument.dom;

import java.util.HashMap;
import java.util.Map;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jopendocument.dom.ODNode;
import org.jopendocument.dom.ODPackage;
import org.jopendocument.dom.StyleDesc;
import org.jopendocument.dom.XMLVersion;
import org.jopendocument.dom.spreadsheet.CellStyle;
import org.jopendocument.dom.spreadsheet.ColumnStyle;
import org.jopendocument.dom.spreadsheet.RowStyle;
import org.jopendocument.dom.spreadsheet.TableStyle;

public class StyleStyle
extends ODNode {
    private static final Map<XMLVersion, Map<String, StyleDesc<?>>> family2Desc;
    private static final Map<XMLVersion, Map<Class<? extends StyleStyle>, StyleDesc<?>>> class2Desc;
    private static boolean descsLoaded;
    private final StyleDesc<?> desc;
    private final ODPackage pkg;
    private final String name;
    private final String family;
    private final XMLVersion ns;

    private static void loadDescs() {
        if (!descsLoaded) {
            StyleStyle.registerAllVersions(CellStyle.DESC);
            StyleStyle.registerAllVersions(RowStyle.DESC);
            StyleStyle.registerAllVersions(ColumnStyle.DESC);
            StyleStyle.registerAllVersions(TableStyle.DESC);
            descsLoaded = true;
        }
    }

    private static void registerAllVersions(StyleDesc<? extends StyleStyle> styleDesc) {
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            if (xMLVersion == styleDesc.getVersion()) {
                StyleStyle.register(styleDesc);
                continue;
            }
            StyleStyle.register(StyleDesc.copy(styleDesc, xMLVersion));
        }
    }

    public static void register(StyleDesc<? extends StyleStyle> styleDesc) {
        if (family2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getFamily(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getFamily() + " duplicate");
        }
        if (class2Desc.get((Object)styleDesc.getVersion()).put(styleDesc.getStyleClass(), styleDesc) != null) {
            throw new IllegalStateException(styleDesc.getStyleClass() + " duplicate");
        }
    }

    static <S extends StyleStyle> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion) {
        return StyleStyle.getStyleDesc(clazz, xMLVersion, true);
    }

    private static <S extends StyleStyle> StyleDesc<S> getStyleDesc(Class<S> clazz, XMLVersion xMLVersion, boolean bl) {
        StyleStyle.loadDescs();
        Map<Class<StyleStyle>, StyleDesc<?>> map = class2Desc.get((Object)xMLVersion);
        if (map.containsKey(clazz)) {
            return map.get(clazz);
        }
        if (bl) {
            throw new IllegalArgumentException("unregistered " + clazz + " for version " + xMLVersion);
        }
        return null;
    }

    public StyleStyle(ODPackage oDPackage, Element element) {
        super(element);
        this.pkg = oDPackage;
        this.name = this.getElement().getAttributeValue("name", this.getSTYLE());
        this.family = this.getElement().getAttributeValue("family", this.getSTYLE());
        this.ns = this.pkg.getVersion();
        this.desc = StyleStyle.getStyleDesc(this.getClass(), this.ns, false);
        if (this.desc != null && !this.desc.getFamily().equals(this.getFamily())) {
            throw new IllegalArgumentException("expected " + this.desc.getFamily() + " but got " + this.getFamily() + " for " + element);
        }
        assert (this.pkg.getXMLFile(this.getElement().getDocument()) != null);
        assert (this.pkg.getVersion() == XMLVersion.getVersion(this.getElement()));
    }

    protected final Namespace getSTYLE() {
        return this.getElement().getNamespace("style");
    }

    public final XMLVersion getNS() {
        return this.ns;
    }

    public final String getName() {
        return this.name;
    }

    public final String getFamily() {
        return this.family;
    }

    public final boolean equals(Object object) {
        if (!(object instanceof StyleStyle)) {
            return false;
        }
        StyleStyle styleStyle = (StyleStyle)object;
        return this.getName().equals(styleStyle.getName()) && this.getFamily().equals(styleStyle.getFamily());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.getFamily().hashCode();
    }

    static {
        descsLoaded = false;
        family2Desc = new HashMap();
        class2Desc = new HashMap();
        for (XMLVersion xMLVersion : XMLVersion.values()) {
            family2Desc.put(xMLVersion, new HashMap());
            class2Desc.put(xMLVersion, new HashMap());
        }
    }
}

