/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.conflict.ConflictAddCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveComparator;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationMemberData;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.MultiFetchServerObjectReader;
import org.openstreetmap.josm.io.OsmServerChangesetReader;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import reverter.DataSetCommandMerger;
import reverter.OsmServerMultiObjectReader;
import reverter.RevertRedactedChangesetException;

public class ChangesetReverter {
    public static final Collection<Long> MODERATOR_REDACTION_ACCOUNTS = Collections.unmodifiableCollection(Arrays.asList(722137L, 760215L));
    public final int changesetId;
    public final Changeset changeset;
    public final RevertType revertType;
    private final OsmDataLayer layer;
    private final DataSet ds;
    private final ChangesetDataSet cds;
    private final DataSet ods;
    private DataSet nds;
    private final HashSet<PrimitiveId> missing = new HashSet();
    private final HashSet<HistoryOsmPrimitive> created = new HashSet();
    private final HashSet<HistoryOsmPrimitive> updated = new HashSet();
    private final HashSet<HistoryOsmPrimitive> deleted = new HashSet();
    private final HashMap<PrimitiveId, Integer> earliestVersions = new HashMap();

    private void addIfMissing(PrimitiveId id) {
        OsmPrimitive p = this.ds.getPrimitiveById(id);
        if (p == null || p.isIncomplete()) {
            this.missing.add(id);
        }
    }

    private void addMissingHistoryIds(Iterable<HistoryOsmPrimitive> primitives) {
        for (HistoryOsmPrimitive p : primitives) {
            this.addIfMissing(p.getPrimitiveId());
        }
    }

    private void addMissingId(OsmPrimitive p) {
        this.addIfMissing((PrimitiveId)p);
        if (p.getType() == OsmPrimitiveType.WAY) {
            for (Node nd : ((Way)p).getNodes()) {
                this.addIfMissing((PrimitiveId)nd);
            }
        }
    }

    private boolean checkOsmChangeEntry(ChangesetDataSet.ChangesetDataSetEntry entry) {
        if (this.revertType == RevertType.FULL) {
            return true;
        }
        if (this.revertType == RevertType.SELECTION_WITH_UNDELETE && entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED) {
            return true;
        }
        if (this.ods == null) {
            return false;
        }
        OsmPrimitive p = this.ods.getPrimitiveById(entry.getPrimitive().getPrimitiveId());
        if (p == null) {
            return false;
        }
        return p.isSelected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangesetReverter(int changesetId, RevertType revertType, boolean newLayer, DataSet ods, ProgressMonitor monitor) throws OsmTransferException, RevertRedactedChangesetException {
        this.changesetId = changesetId;
        OsmDataLayer editLayer = MainApplication.getLayerManager().getEditLayer();
        boolean bl = newLayer = newLayer || editLayer == null;
        if (newLayer) {
            this.ds = new DataSet();
            this.layer = new OsmDataLayer(this.ds, I18n.tr((String)"Reverted changeset", (Object[])new Object[0]) + I18n.tr((String)" [id: {0}]", (Object[])new Object[]{String.valueOf(changesetId)}), null);
        } else {
            this.layer = editLayer;
            this.ds = editLayer.data;
        }
        this.ods = ods;
        this.revertType = revertType;
        if (!(revertType != RevertType.SELECTION && revertType != RevertType.SELECTION_WITH_UNDELETE || ods != null && !ods.getAllSelected().isEmpty())) {
            throw new IllegalArgumentException("No selected elements with revert type " + revertType);
        }
        OsmServerChangesetReader csr = new OsmServerChangesetReader(true);
        monitor.beginTask("", 2);
        this.changeset = csr.readChangeset((long)changesetId, false, monitor.createSubTaskMonitor(1, false));
        if (MODERATOR_REDACTION_ACCOUNTS.contains(this.changeset.getUser().getId())) {
            throw new RevertRedactedChangesetException(I18n.tr((String)"It is not allowed to revert changeset from {0}", (Object[])new Object[]{this.changeset.getUser().getName()}));
        }
        try {
            this.cds = csr.downloadChangeset(changesetId, monitor.createSubTaskMonitor(1, false));
        }
        finally {
            monitor.finishTask();
            if (newLayer) {
                GuiHelper.runInEDT(() -> MainApplication.getLayerManager().addLayer((Layer)this.layer));
            }
        }
        this.buildCreatedUpdatedModifiedObjectLists();
    }

    private void buildCreatedUpdatedModifiedObjectLists() {
        for (PrimitiveId id : this.cds.getIds()) {
            ChangesetDataSet.ChangesetDataSetEntry first = this.cds.getFirstEntry(id);
            this.earliestVersions.put(id, (int)first.getPrimitive().getVersion());
            ChangesetDataSet.ChangesetDataSetEntry entry = first.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED ? first : this.cds.getLastEntry(id);
            if (!this.checkOsmChangeEntry(entry)) continue;
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED) {
                this.created.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.UPDATED) {
                this.updated.add(entry.getPrimitive());
                continue;
            }
            if (entry.getModificationType() != ChangesetDataSet.ChangesetModificationType.DELETED) continue;
            this.deleted.add(entry.getPrimitive());
        }
    }

    public void checkMissingCreated() {
        this.addMissingHistoryIds(this.created);
    }

    public void checkMissingUpdated() {
        this.addMissingHistoryIds(this.updated);
    }

    public void checkMissingDeleted() {
        this.addMissingHistoryIds(this.deleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadObjectsHistory(ProgressMonitor progressMonitor) throws OsmTransferException {
        OsmServerMultiObjectReader rdr = new OsmServerMultiObjectReader();
        int num = this.updated.size() + this.deleted.size();
        progressMonitor.beginTask(this.addChangesetIdPrefix(I18n.trn((String)"Downloading history for {0} object", (String)"Downloading history for {0} objects", (long)num, (Object[])new Object[]{num})), num + 1);
        try {
            HashMap<Long, Integer> nodeList = new HashMap<Long, Integer>();
            HashMap<Long, Integer> wayList = new HashMap<Long, Integer>();
            HashMap<Long, Integer> relationList = new HashMap<Long, Integer>();
            for (HashSet collection : Arrays.asList(this.updated, this.deleted)) {
                block10: for (HistoryOsmPrimitive entry : collection) {
                    PrimitiveId id = entry.getPrimitiveId();
                    Integer earliestVersion = this.earliestVersions.get(id);
                    if (earliestVersion == null || earliestVersion <= 1) {
                        throw new OsmTransferException(I18n.tr((String)"Unexpected data in changeset #{1}", (Object[])new Object[]{String.valueOf(this.changesetId)}));
                    }
                    switch (id.getType()) {
                        case NODE: {
                            nodeList.put(id.getUniqueId(), earliestVersion - 1);
                            continue block10;
                        }
                        case WAY: {
                            wayList.put(id.getUniqueId(), earliestVersion - 1);
                            continue block10;
                        }
                        case RELATION: {
                            relationList.put(id.getUniqueId(), earliestVersion - 1);
                            continue block10;
                        }
                    }
                    throw new AssertionError();
                }
            }
            rdr.readMultiObjectsOrNextOlder(OsmPrimitiveType.NODE, nodeList, progressMonitor);
            rdr.readMultiObjectsOrNextOlder(OsmPrimitiveType.WAY, wayList, progressMonitor);
            rdr.readMultiObjectsOrNextOlder(OsmPrimitiveType.RELATION, relationList, progressMonitor);
            if (progressMonitor.isCanceled()) {
                return;
            }
            this.nds = rdr.parseOsm(progressMonitor.createSubTaskMonitor(1, true));
            this.ds.update(this::addPartialPrimitives);
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private void addPartialPrimitives() {
        block5: for (OsmPrimitive p : this.nds.allPrimitives()) {
            if (!p.isIncomplete()) {
                this.addMissingId(p);
                continue;
            }
            if (this.ds.getPrimitiveById(p.getPrimitiveId()) != null) continue;
            switch (p.getType()) {
                case NODE: {
                    this.ds.addPrimitive((OsmPrimitive)new Node(p.getUniqueId()));
                    continue block5;
                }
                case WAY: 
                case CLOSEDWAY: {
                    this.ds.addPrimitive((OsmPrimitive)new Way(p.getUniqueId()));
                    continue block5;
                }
                case RELATION: 
                case MULTIPOLYGON: {
                    this.ds.addPrimitive((OsmPrimitive)new Relation(p.getUniqueId()));
                    continue block5;
                }
            }
            throw new AssertionError();
        }
    }

    public void downloadMissingPrimitives(ProgressMonitor monitor) throws OsmTransferException {
        if (!this.hasMissingObjects()) {
            return;
        }
        MultiFetchServerObjectReader rdr = MultiFetchServerObjectReader.create((boolean)false);
        block5: for (PrimitiveId id : this.missing) {
            switch (id.getType()) {
                case NODE: {
                    rdr.append((OsmPrimitive)new Node(id.getUniqueId()));
                    continue block5;
                }
                case WAY: 
                case CLOSEDWAY: {
                    rdr.append((OsmPrimitive)new Way(id.getUniqueId()));
                    continue block5;
                }
                case RELATION: 
                case MULTIPOLYGON: {
                    rdr.append((OsmPrimitive)new Relation(id.getUniqueId()));
                    continue block5;
                }
            }
            throw new AssertionError();
        }
        DataSet source = rdr.parseOsm(monitor);
        for (OsmPrimitive p : source.allPrimitives()) {
            if (p.isVisible() || p.isDeleted()) continue;
            p.setDeleted(true);
            p.setModified(false);
        }
        this.layer.mergeFrom(source);
        this.missing.clear();
    }

    private static Conflict<? extends OsmPrimitive> createConflict(OsmPrimitive p, boolean isMyDeleted) {
        switch (p.getType()) {
            case NODE: {
                return new Conflict((OsmPrimitive)((Node)p), (OsmPrimitive)new Node((Node)p), isMyDeleted);
            }
            case WAY: 
            case CLOSEDWAY: {
                return new Conflict((OsmPrimitive)((Way)p), (OsmPrimitive)new Way((Way)p), isMyDeleted);
            }
            case RELATION: 
            case MULTIPOLYGON: {
                return new Conflict((OsmPrimitive)((Relation)p), (OsmPrimitive)new Relation((Relation)p), isMyDeleted);
            }
        }
        throw new AssertionError();
    }

    private boolean hasEqualSemanticAttributes(OsmPrimitive current, HistoryOsmPrimitive history) {
        if (!current.getKeys().equals((Object)history.getTags())) {
            return false;
        }
        switch (current.getType()) {
            case NODE: {
                return ChangesetReverter.hasEqualSemanticAttributesNode(this.nds, (HistoryNode)history, (Node)current);
            }
            case WAY: 
            case CLOSEDWAY: {
                return ChangesetReverter.hasEqualSemanticAttributesWay((HistoryWay)history, (Way)current);
            }
            case RELATION: 
            case MULTIPOLYGON: {
                return ChangesetReverter.hasEqualSemanticAttributesRelation((HistoryRelation)history, (Relation)current);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasEqualSemanticAttributesNode(DataSet nds, HistoryNode history, Node current) {
        LatLon historyCoor;
        LatLon currentCoor = current.getCoor();
        if (Objects.equals(currentCoor, historyCoor = history.getCoords())) {
            return true;
        }
        if (currentCoor != null && historyCoor == null) {
            LatLon previousCoor = ((Node)nds.getPrimitiveById(history.getPrimitiveId())).getCoor();
            return previousCoor != null && previousCoor.equals((Object)currentCoor);
        }
        return false;
    }

    private static boolean hasEqualSemanticAttributesWay(HistoryWay history, Way current) {
        List currentNodes = current.getNodes();
        List historyNodes = history.getNodes();
        if (currentNodes.size() != historyNodes.size()) {
            return false;
        }
        for (int i = 0; i < currentNodes.size(); ++i) {
            if (((Node)currentNodes.get(i)).getId() == ((Long)historyNodes.get(i)).longValue()) continue;
            return false;
        }
        return true;
    }

    private static boolean hasEqualSemanticAttributesRelation(HistoryRelation history, Relation current) {
        List currentMembers = current.getMembers();
        List historyMembers = history.getMembers();
        if (currentMembers.size() != historyMembers.size()) {
            return false;
        }
        for (int i = 0; i < currentMembers.size(); ++i) {
            RelationMember currentMember = (RelationMember)currentMembers.get(i);
            RelationMemberData historyMember = (RelationMemberData)historyMembers.get(i);
            if (!currentMember.getRole().equals(historyMember.getRole())) {
                return false;
            }
            if (currentMember.getMember().getPrimitiveId().equals(new SimplePrimitiveId(historyMember.getMemberId(), historyMember.getMemberType()))) continue;
            return false;
        }
        return true;
    }

    public List<Command> getCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        if (this.nds == null) {
            return cmds;
        }
        DataSetCommandMerger merger = new DataSetCommandMerger(this.nds, this.ds);
        cmds.addAll(merger.getCommandList());
        HashSet<OsmPrimitive> toDelete = new HashSet<OsmPrimitive>();
        for (OsmPrimitive p : this.nds.allPrimitives()) {
            OsmPrimitive dp;
            if (p.isVisible() || (dp = this.ds.getPrimitiveById((PrimitiveId)p)) == null) continue;
            toDelete.add(dp);
        }
        for (HistoryOsmPrimitive id : this.created) {
            OsmPrimitive p = this.ds.getPrimitiveById(id.getPrimitiveId());
            if (p == null) continue;
            toDelete.add(p);
        }
        HashSet<OsmPrimitive> conflicted = new HashSet<OsmPrimitive>();
        for (Conflict conflict : merger.getConflicts()) {
            cmds.add((Command)new ConflictAddCommand(this.layer.data, conflict));
        }
        this.checkObjectVersions(cmds, conflicted, toDelete);
        this.checkForDeletedReferrers(cmds, conflicted, toDelete);
        return cmds;
    }

    private void checkObjectVersions(List<Command> cmds, Set<OsmPrimitive> conflicted, Set<OsmPrimitive> toDelete) {
        for (ChangesetDataSet.ChangesetDataSetEntry entry : this.cds) {
            if (!this.checkOsmChangeEntry(entry) || !ChangesetReverter.checkModificationType(this.cds, entry, this.revertType)) continue;
            HistoryOsmPrimitive hp = entry.getPrimitive();
            OsmPrimitive dp = this.ds.getPrimitiveById(hp.getPrimitiveId());
            if (dp == null || dp.isIncomplete()) {
                throw new IllegalStateException(this.addChangesetIdPrefix(I18n.tr((String)"Missing merge target for {0}", (Object[])new Object[]{hp.getPrimitiveId()})));
            }
            if (!this.checkObjectVersionsNotSemanticallySame(toDelete, hp, dp)) continue;
            cmds.add((Command)new ConflictAddCommand(this.layer.data, ChangesetReverter.createConflict(dp, entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.CREATED)));
            conflicted.add(dp);
        }
    }

    private static boolean checkModificationType(ChangesetDataSet cds, ChangesetDataSet.ChangesetDataSetEntry entry, RevertType revertType) {
        if (entry.getModificationType() == ChangesetDataSet.ChangesetModificationType.DELETED && revertType == RevertType.SELECTION_WITH_UNDELETE) {
            ChangesetDataSet.ChangesetDataSetEntry first = cds.getFirstEntry(entry.getPrimitive().getPrimitiveId());
            return first.getModificationType() != ChangesetDataSet.ChangesetModificationType.CREATED;
        }
        return true;
    }

    private boolean checkObjectVersionsNotSemanticallySame(Set<OsmPrimitive> toDelete, HistoryOsmPrimitive hp, OsmPrimitive dp) {
        return !(hp.getVersion() == (long)dp.getVersion() || !hp.isVisible() && !dp.isVisible() || this.hasEqualSemanticAttributes(dp, hp) || toDelete.contains(dp) && dp.isDeleted());
    }

    private void checkForDeletedReferrers(List<Command> cmds, Set<OsmPrimitive> conflicted, Set<OsmPrimitive> toDelete) {
        boolean restartNeeded;
        List<OsmPrimitive> delSorted = toDelete.stream().filter(p -> !p.isDeleted()).sorted(OsmPrimitiveComparator.orderingRelationsWaysNodes()).collect(Collectors.toList());
        do {
            restartNeeded = false;
            for (int i = 0; i < delSorted.size() && !restartNeeded; ++i) {
                OsmPrimitive p2 = (OsmPrimitive)delSorted.get(i);
                restartNeeded = this.checkForDeletedReferrersPrimitive(cmds, conflicted, toDelete, delSorted, p2, i);
            }
        } while (restartNeeded);
        delSorted.retainAll(toDelete);
        if (!delSorted.isEmpty()) {
            cmds.add((Command)new DeleteCommand(delSorted));
        }
    }

    private boolean checkForDeletedReferrersPrimitive(List<Command> cmds, Set<OsmPrimitive> conflicted, Set<OsmPrimitive> toDelete, List<OsmPrimitive> delSorted, OsmPrimitive p, int i) {
        for (OsmPrimitive referrer : p.getReferrers()) {
            if (toDelete.contains(referrer) || this.nds.getPrimitiveById((PrimitiveId)referrer) != null) continue;
            if (conflicted.add(p)) {
                cmds.add((Command)new ConflictAddCommand(this.layer.data, ChangesetReverter.createConflict(p, true)));
                if (p instanceof Relation) {
                    for (int j = 0; j < i; ++j) {
                        if (!delSorted.get(j).getReferrers().contains(p)) continue;
                        return true;
                    }
                }
            }
            toDelete.remove(p);
            return false;
        }
        return false;
    }

    public boolean hasMissingObjects() {
        return !this.missing.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixNodesWithoutCoordinates(ProgressMonitor progressMonitor) throws OsmTransferException {
        ArrayList<Node> nodes = new ArrayList<Node>(this.nds.getNodes());
        int num = nodes.size();
        progressMonitor.beginTask(this.addChangesetIdPrefix(I18n.trn((String)"Checking coordinates of {0} node", (String)"Checking coordinates of {0} nodes", (long)num, (Object[])new Object[]{num})), 2 * num + 1);
        nodes.removeIf(n -> {
            if (n.isDeleted() || n.isLatLonKnown()) {
                return true;
            }
            PrimitiveId id = n.getPrimitiveId();
            OsmPrimitive p = this.ds.getPrimitiveById(id);
            return !(p instanceof Node) || ((Node)p).isLatLonKnown() || p.getVersion() <= 1;
        });
        progressMonitor.worked(num - nodes.size());
        Map<Long, Integer> versionMap = nodes.stream().collect(Collectors.toMap(AbstractPrimitive::getUniqueId, id -> Math.max(1, Optional.ofNullable(this.ds.getPrimitiveById((PrimitiveId)id)).orElse((OsmPrimitive)id).getVersion() - 1)));
        try {
            while (!versionMap.isEmpty()) {
                OsmServerMultiObjectReader rds = new OsmServerMultiObjectReader();
                ProgressMonitor subMonitor = progressMonitor.createSubTaskMonitor(num, false);
                subMonitor.beginTask(I18n.tr((String)"Fetching multi-objects", (Object[])new Object[0]), versionMap.size());
                rds.readMultiObjectsOrNextOlder(OsmPrimitiveType.NODE, versionMap, subMonitor);
                subMonitor.finishTask();
                DataSet history = rds.parseOsm(progressMonitor.createSubTaskMonitor(0, false));
                this.ds.update(() -> this.updateNodes(progressMonitor, nodes, versionMap, history));
                versionMap.values().removeIf(i -> i <= 1);
                versionMap.replaceAll((key, value) -> value - 1);
                if (!progressMonitor.isCanceled()) continue;
                break;
            }
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    private void updateNodes(ProgressMonitor progressMonitor, Collection<Node> nodes, Map<Long, Integer> versionMap, DataSet history) {
        for (Node n : nodes) {
            Node historyNode;
            if (!n.isDeleted() && !n.isLatLonKnown() && (historyNode = (Node)history.getPrimitiveById((PrimitiveId)n)) != null) {
                if (historyNode.isLatLonKnown() && this.changeset.getClosedAt().isAfter(historyNode.getInstant())) {
                    n.load((PrimitiveData)historyNode.save());
                    progressMonitor.worked(1);
                } else {
                    versionMap.put(n.getId(), historyNode.getVersion());
                }
            }
            if (!progressMonitor.isCanceled()) continue;
            break;
        }
    }

    String addChangesetIdPrefix(String msg) {
        return I18n.tr((String)"Changeset {0}: {1}", (Object[])new Object[]{Long.toString(this.changesetId), msg});
    }

    public static enum RevertType {
        FULL,
        SELECTION,
        SELECTION_WITH_UNDELETE;

    }
}

