/*
 * Decompiled with CFR 0.152.
 */
package reverter;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import reverter.ChangesetReverter;
import reverter.RevertChangesetTask;

public class RevertChangesetHandler
extends RequestHandler {
    public static final String COMMAND = "revert_changeset";
    private static final String PERMISSION_KEY = "remotecontrol.permission.revert_changeset";
    private static final boolean PERMISSION_DEFAULT = true;
    private final List<Integer> changesetIds = new ArrayList<Integer>();

    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException {
        try {
            MainApplication.worker.submit((Runnable)((Object)new RevertChangesetTask(this.changesetIds, ChangesetReverter.RevertType.FULL, true, false)));
        }
        catch (Exception ex) {
            Logging.debug((String)"RemoteControl: Error parsing revert_changeset remote control request:");
            Logging.debug((Throwable)ex);
            throw new RequestHandler.RequestHandlerErrorException((Throwable)ex);
        }
    }

    public String[] getMandatoryParams() {
        return new String[]{"id"};
    }

    public PermissionPrefWithDefault getPermissionPref() {
        return new PermissionPrefWithDefault(PERMISSION_KEY, true, I18n.tr((String)"Revert changeset(s)", (Object[])new Object[0]));
    }

    public String getPermissionMessage() {
        return I18n.tr((String)"Remote Control has been asked to revert a changeset.", (Object[])new Object[0]);
    }

    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        if (this.args.get("id") != null) {
            try {
                for (String id : ((String)this.args.get("id")).split(",", -1)) {
                    this.changesetIds.add(Integer.parseInt(id));
                }
            }
            catch (NumberFormatException e) {
                throw new RequestHandler.RequestHandlerBadRequestException("NumberFormatException: " + e.getMessage());
            }
        } else {
            throw new RequestHandler.RequestHandlerBadRequestException("The required id argument must be specified");
        }
    }
}

