/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.elevation.grid;

import java.io.IOException;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.jcs3.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCachedTileLoaderJob;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileJobOptions;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ElevationGridTileLoader
extends TMSCachedTileLoader {
    public ElevationGridTileLoader(TileLoaderListener listener, ICacheAccess<String, BufferedImageCacheEntry> cache, TileJobOptions options) {
        super(listener, cache, options);
    }

    public TileJob createTileLoaderJob(Tile tile) {
        CheckParameterUtil.ensureParameterNotNull((Object)tile);
        return new ElevationGridTileJob(this.listener, tile, (ICacheAccess<String, BufferedImageCacheEntry>)this.cache, this.options, this.getDownloadExecutor());
    }

    public void cancelOutstandingTasks() {
    }

    static class ElevationGridTileJob
    extends JCSCachedTileLoaderJob<String, BufferedImageCacheEntry>
    implements TileJob {
        private final Tile tile;
        private final TileLoaderListener listener;

        protected ElevationGridTileJob(TileLoaderListener listener, Tile tile, ICacheAccess<String, BufferedImageCacheEntry> cache, TileJobOptions options, ThreadPoolExecutor downloadJobExecutor) {
            super(cache, options, downloadJobExecutor);
            this.tile = tile;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Tile tile = this.tile;
            synchronized (tile) {
                if (this.tile.isLoaded() && !this.tile.hasError() || this.tile.isLoading()) {
                    return;
                }
                this.tile.initLoading();
            }
            try {
                this.tile.loadImage(null);
                this.tile.setLoaded(true);
                this.listener.tileLoadingFinished(this.tile, true);
            }
            catch (Exception e) {
                this.tile.setError(e.getMessage());
                this.listener.tileLoadingFinished(this.tile, false);
            }
            finally {
                this.tile.finishLoading();
            }
        }

        public void submit() {
            this.run();
        }

        public void submit(boolean force) {
            this.submit();
        }

        public String getCacheKey() {
            if (this.tile != null) {
                TileSource tileSource = this.tile.getTileSource();
                return Optional.ofNullable(tileSource.getName()).orElse("").replace(':', '_') + ":" + tileSource.getTileId(this.tile.getZoom(), this.tile.getXtile(), this.tile.getYtile());
            }
            return null;
        }

        public URL getUrl() throws IOException {
            return new URL(String.format("http://localhost/elevation/%d/%d", this.tile.getTileXY().getXIndex(), this.tile.getTileXY().getYIndex()));
        }

        protected BufferedImageCacheEntry createCacheEntry(byte[] content) {
            return new BufferedImageCacheEntry(content);
        }
    }
}

