/*
 * Decompiled with CFR 0.152.
 */
package com.innovant.josm.plugin.routing.gui;

import com.innovant.josm.jrt.core.RoutingGraph;
import com.innovant.josm.plugin.routing.RoutingLayer;
import com.innovant.josm.plugin.routing.RoutingModel;
import com.innovant.josm.plugin.routing.RoutingPlugin;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;

public class RoutingMenu
extends JMenu {
    private static final long serialVersionUID = 3559922048225708480L;
    private final JMenuItem startMI;
    private final JMenuItem reverseMI;
    private final JMenuItem clearMI;
    private final JMenuItem regraphMI;
    private final JMenu criteriaM;
    private final JMenu menu;

    public RoutingMenu() {
        MainMenu mm = MainApplication.getMenu();
        this.menu = mm.addMenu("Routing", I18n.tr((String)"Routing", (Object[])new Object[0]), 79, mm.getDefaultMenuPos(), HelpUtil.ht((String)"/Plugin/Routing"));
        this.startMI = new JMenuItem(I18n.tr((String)"Add routing layer", (Object[])new Object[0]));
        this.startMI.addActionListener(e -> RoutingPlugin.getInstance().addLayer());
        this.menu.add(this.startMI);
        this.menu.addSeparator();
        ButtonGroup group = new ButtonGroup();
        this.criteriaM = new JMenu(I18n.tr((String)"Criteria", (Object[])new Object[0]));
        JRadioButtonMenuItem rshorter = new JRadioButtonMenuItem(I18n.tr((String)"Shortest", (Object[])new Object[0]));
        rshorter.setSelected(true);
        rshorter.addItemListener(e -> {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
                RoutingModel routingModel = layer.getRoutingModel();
                if (e.getStateChange() == 1) {
                    routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.SHORTEST);
                } else {
                    routingModel.routingGraph.setTypeRoute(RoutingGraph.RouteType.FASTEST);
                }
                routingModel.setNodesChanged();
                MainApplication.getMap().repaint();
            }
        });
        JRadioButtonMenuItem rfaster = new JRadioButtonMenuItem(I18n.tr((String)"Fastest", (Object[])new Object[0]));
        group.add(rshorter);
        group.add(rfaster);
        this.criteriaM.add(rshorter);
        this.criteriaM.add(rfaster);
        this.criteriaM.addSeparator();
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(I18n.tr((String)"Ignore oneways", (Object[])new Object[0]));
        cbmi.addItemListener(e -> {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
                RoutingModel routingModel = layer.getRoutingModel();
                routingModel.routingGraph.getRoutingProfile().setOnewayUse(e.getStateChange() != 1);
                routingModel.setNodesChanged();
                routingModel.setOnewayChanged();
                MainApplication.getMap().repaint();
            }
        });
        this.criteriaM.add(cbmi);
        this.menu.add(this.criteriaM);
        this.menu.addSeparator();
        this.reverseMI = new JMenuItem(I18n.tr((String)"Reverse route", (Object[])new Object[0]));
        this.reverseMI.addActionListener(e -> {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
                RoutingModel routingModel = layer.getRoutingModel();
                routingModel.reverseNodes();
                MainApplication.getMap().repaint();
            }
        });
        this.menu.add(this.reverseMI);
        this.clearMI = new JMenuItem(I18n.tr((String)"Clear route", (Object[])new Object[0]));
        this.clearMI.addActionListener(e -> {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
                RoutingModel routingModel = layer.getRoutingModel();
                routingModel.reset();
                RoutingPlugin.getInstance().getRoutingDialog().clearNodes();
                MainApplication.getMap().repaint();
            }
        });
        this.menu.add(this.clearMI);
        this.regraphMI = new JMenuItem(I18n.tr((String)"Reconstruct Graph", (Object[])new Object[0]));
        this.regraphMI.addActionListener(e -> {
            if (MainApplication.getLayerManager().getActiveLayer() instanceof RoutingLayer) {
                RoutingLayer layer = (RoutingLayer)MainApplication.getLayerManager().getActiveLayer();
                RoutingModel routingModel = layer.getRoutingModel();
                routingModel.routingGraph.resetGraph();
                routingModel.routingGraph.createGraph();
            }
        });
        this.menu.add(this.regraphMI);
        this.disableAllItems();
    }

    public void disableAllItems() {
        this.startMI.setEnabled(false);
        this.reverseMI.setEnabled(false);
        this.clearMI.setEnabled(false);
        this.criteriaM.setEnabled(false);
        this.regraphMI.setEnabled(false);
    }

    public void enableStartItem() {
        this.startMI.setEnabled(true);
    }

    public void enableRestOfItems() {
        this.reverseMI.setEnabled(true);
        this.clearMI.setEnabled(true);
        this.criteriaM.setEnabled(true);
        this.regraphMI.setEnabled(true);
    }

    public void disableRestOfItems() {
        this.reverseMI.setEnabled(false);
        this.clearMI.setEnabled(false);
        this.criteriaM.setEnabled(false);
        this.regraphMI.setEnabled(false);
    }
}

