/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pdfimport;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.plugins.pdfimport.Preferences;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class PreferenceSettingsGui {
    private ModeChoice[] choices = new ModeChoice[]{new ModeChoice(Preferences.GuiMode.Auto, I18n.tr((String)"Auto", (Object[])new Object[0])), new ModeChoice(Preferences.GuiMode.Simple, I18n.tr((String)"Basic", (Object[])new Object[0])), new ModeChoice(Preferences.GuiMode.Expert, I18n.tr((String)"Extended", (Object[])new Object[0]))};
    private final String guiAuto = I18n.tr((String)"Auto", (Object[])new Object[0]);
    private final String guiBasic = I18n.tr((String)"Basic", (Object[])new Object[0]);
    private final String guiExtended = I18n.tr((String)"Extended", (Object[])new Object[0]);
    private String[] guiPrefs = new String[]{this.guiAuto, this.guiBasic, this.guiExtended};
    private JComboBox<String> guiPrefsCombo = new JComboBox<String>(this.guiPrefs);
    private JPanel panel;

    public JPanel getGui() {
        int guiCode;
        if (this.panel == null) {
            this.build();
        }
        if ((guiCode = Preferences.getGuiCode()) == 1) {
            this.guiPrefsCombo.setSelectedItem(this.guiExtended);
        }
        if (guiCode == 2) {
            this.guiPrefsCombo.setSelectedItem(this.guiBasic);
        }
        return this.panel;
    }

    public boolean save() {
        String s = (String)this.guiPrefsCombo.getSelectedItem();
        if (s == this.guiAuto) {
            Preferences.setGuiCode(0);
        }
        if (s == this.guiBasic) {
            Preferences.setGuiCode(2);
        }
        if (s == this.guiExtended) {
            Preferences.setGuiCode(1);
        }
        return true;
    }

    private void build() {
        this.panel = new JPanel(new FlowLayout(3));
        this.panel.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"User Interface", (Object[])new Object[0])));
        JLabel l = new JLabel(I18n.tr((String)"Interactions:", (Object[])new Object[0]));
        this.panel.add((Component)l, GBC.std());
        this.panel.add(this.guiPrefsCombo, GBC.eop());
        this.guiPrefsCombo.setBackground(Color.red);
        this.guiPrefsCombo.setAlignmentX(1.0f);
    }

    private static class ModeChoice {
        public Preferences.GuiMode guiMode;
        public String name;

        ModeChoice(Preferences.GuiMode guiMode, String name) {
            this.guiMode = guiMode;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

