/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo;

import jakarta.json.JsonObject;

class ReverseRecord {
    private String countryCode;
    private String country;
    private String state;
    private String stateDistrict;
    private String county;
    private String city;
    private String town;
    private String village;
    private String cityDistrict;
    private String suburb;

    ReverseRecord() {
        this.init();
    }

    ReverseRecord(JsonObject obj) {
        this.init();
        JsonObject address = obj.getJsonObject("address");
        if (address != null) {
            this.countryCode = address.getString("country_code", null);
            this.country = address.getString("country", null);
            this.state = address.getString("state", null);
            this.stateDistrict = address.getString("state_district", null);
            this.county = address.getString("county", null);
            this.city = address.getString("city", null);
            this.town = address.getString("town", null);
            this.village = address.getString("village", null);
            this.cityDistrict = address.getString("city_district", null);
            this.suburb = address.getString("suburb", null);
        }
    }

    private void init() {
        this.countryCode = null;
        this.country = null;
        this.state = null;
        this.stateDistrict = null;
        this.county = null;
        this.city = null;
        this.town = null;
        this.village = null;
        this.cityDistrict = null;
        this.suburb = null;
    }

    public boolean matchAnyArea(String area) {
        if (area.equals(this.countryCode)) {
            return true;
        }
        if (area.equals(this.country)) {
            return true;
        }
        if (area.equals(this.state)) {
            return true;
        }
        if (area.equals(this.stateDistrict)) {
            return true;
        }
        if (area.equals(this.county)) {
            return true;
        }
        if (area.equals(this.city)) {
            return true;
        }
        if (area.equals(this.town)) {
            return true;
        }
        if (area.equals(this.village)) {
            return true;
        }
        if (area.equals(this.cityDistrict)) {
            return true;
        }
        return area.equals(this.suburb);
    }
}

