/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.cubemap;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cache.StreetsideCache;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapBox;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.plugins.streetside.cubemap.ITileDownloadingTaskListener;
import org.openstreetmap.josm.plugins.streetside.cubemap.TileDownloadingTask;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.StreetsideViewerPanel;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ThreeSixtyDegreeViewerPanel;
import org.openstreetmap.josm.plugins.streetside.utils.GraphicsUtils;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;
import org.openstreetmap.josm.tools.Logging;

public final class CubemapBuilder
implements ITileDownloadingTaskListener,
StreetsideDataListener {
    private static final Logger LOGGER = Logger.getLogger(CubemapBuilder.class.getCanonicalName());
    private static CubemapBuilder instance;
    boolean isBuilding;
    private StreetsideAbstractImage cubemap;
    private long startTime;
    private final Map<CubeMapTileXY, BufferedImage> tileImages = new ConcurrentHashMap<CubeMapTileXY, BufferedImage>();
    private final ExecutorService pool = Executors.newVirtualThreadPerTaskExecutor();
    private final List<Future<?>> lastFutures = new ArrayList();
    private final AtomicInteger currentTileCount = new AtomicInteger();

    private CubemapBuilder() {
    }

    public static synchronized CubemapBuilder getInstance() {
        if (instance == null) {
            instance = new CubemapBuilder();
        }
        return instance;
    }

    public static synchronized void destroyInstance() {
        instance = null;
    }

    public Map<CubeMapTileXY, BufferedImage> getTileImages() {
        return this.tileImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTileImages(Map<CubeMapTileXY, BufferedImage> tileImages) {
        Map<CubeMapTileXY, BufferedImage> map = this.tileImages;
        synchronized (map) {
            this.tileImages.clear();
            this.tileImages.putAll(tileImages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTileImage(CubeMapTileXY key, BufferedImage value) {
        Map<CubeMapTileXY, BufferedImage> map = this.tileImages;
        synchronized (map) {
            this.tileImages.put(key, value);
        }
    }

    @Override
    public void imagesAdded() {
    }

    @Override
    public void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        this.startTime = System.currentTimeMillis();
        if (newImage != null) {
            this.cubemap = newImage;
            this.currentTileCount.set(0);
            this.resetTileImages();
            this.downloadCubemapImages(this.cubemap);
            long runTime = (System.currentTimeMillis() - this.startTime) / 1000L;
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                LOGGER.log(Logging.LEVEL_DEBUG, "Completed downloading tiles for {0} in {1} seconds.", new Object[]{newImage.id(), runTime});
            }
        }
    }

    public void reload(StreetsideAbstractImage image) {
        if (this.cubemap != null && image.id().equals(this.cubemap.id())) {
            this.tileImages.clear();
            this.downloadCubemapImages(image);
        }
    }

    public Map<CubeMapTileXY, StreetsideCache> downloadCubemapImages(StreetsideAbstractImage image) {
        ThreeSixtyDegreeViewerPanel panel360 = StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel();
        if (panel360 != null && panel360.getScene() != panel360.getLoadingScene()) {
            panel360.setScene(panel360.getLoadingScene());
        }
        int maxThreadCount = 6 * CubemapUtils.getMaxCols(image) * CubemapUtils.getMaxRows(image);
        long startTimeDownloadCubemapImages = System.currentTimeMillis();
        if (!CubemapBuilder.getInstance().getTileImages().keySet().isEmpty()) {
            CubemapBuilder.getInstance().resetTileImages();
        }
        ArrayList<TileDownloadingTask> tasks = new ArrayList<TileDownloadingTask>(maxThreadCount);
        if (Boolean.TRUE.equals(StreetsideProperties.DOWNLOAD_CUBEFACE_TILES_TOGETHER.get())) {
            EnumSet.allOf(CubemapUtils.CubemapFaces.class).forEach(face -> tasks.add(new TileDownloadingTask(image, (CubemapUtils.CubemapFaces)((Object)face), new CubeMapTileXY((CubemapUtils.CubemapFaces)((Object)face), 0, 0))));
        } else {
            int zoom = Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()) ? image.zoomMax() : image.zoomMin();
            for (CubemapUtils.CubemapFaces face2 : CubemapUtils.CubemapFaces.values()) {
                tasks.addAll(image.getFaceTiles(face2, zoom).map(f -> new TileDownloadingTask(image, face2, (CubeMapTileXY)f.a)).toList());
            }
        }
        MainApplication.worker.submit(() -> {
            try {
                List<Future<List<String>>> results;
                List<Future<?>> list = this.lastFutures;
                synchronized (list) {
                    this.lastFutures.forEach(f -> f.cancel(true));
                    this.lastFutures.clear();
                    results = this.pool.invokeAll(tasks, 1L, TimeUnit.MINUTES);
                    this.lastFutures.addAll(results);
                }
                if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                    CubemapBuilder.waitForCompletedTasks(results, startTimeDownloadCubemapImages);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
            }
        });
        long stopTime = System.currentTimeMillis();
        long runTime = stopTime - startTimeDownloadCubemapImages;
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, "Tile imagery downloading tasks completed in {0} seconds.", runTime / 1000L);
        }
        return Collections.emptyMap();
    }

    private static void waitForCompletedTasks(List<Future<List<String>>> results, long startTimeDownloadCubemapImages) throws InterruptedException {
        for (Future<List<String>> ff : results) {
            try {
                LOGGER.log(Logging.LEVEL_DEBUG, "Completed tile downloading task {0} in {1} seconds.", new Object[]{ff.get(), (System.currentTimeMillis() - startTimeDownloadCubemapImages) / 1000L});
            }
            catch (ExecutionException e) {
                LOGGER.log(Logging.LEVEL_ERROR, e.getMessage(), e);
            }
        }
    }

    @Override
    public void tileAdded(StreetsideAbstractImage image, CubeMapTileXY tileXY, BufferedImage bufferedImage) {
        if (!this.cubemap.id().equals(image.id())) {
            return;
        }
        this.addTileImage(tileXY, bufferedImage);
        if (this.currentTileCount.incrementAndGet() == 6 * CubemapUtils.getMaxCols(image) * CubemapUtils.getMaxRows(image)) {
            if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
                long endTime = System.currentTimeMillis();
                long runTime = (endTime - this.startTime) / 1000L;
                LOGGER.log(Logging.LEVEL_DEBUG, "{0} tile images ready for building cumbemap faces for cubemap {1} in {2} seconds.", new Object[]{this.currentTileCount.get(), CubemapBuilder.getInstance().getCubemap().id(), Long.toString(runTime)});
            }
            this.buildCubemapFaces();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCubemapFaces() {
        int i;
        StreetsideViewerDialog.getInstance();
        CubemapBox cubemapBox = StreetsideViewerPanel.getCubemapBox();
        ImageView[] views = cubemapBox.getViews();
        Image[] finalImages = new Image[6];
        int zoom = Boolean.TRUE.equals(StreetsideProperties.SHOW_HIGH_RES_STREETSIDE_IMAGERY.get()) ? this.cubemap.zoomMax() : this.cubemap.zoomMin();
        for (i = 0; i < 6; ++i) {
            Map<CubeMapTileXY, BufferedImage> tiles;
            CubemapUtils.CubemapFaces face = CubemapUtils.CubemapFaces.values()[i];
            Map<CubeMapTileXY, BufferedImage> map = this.tileImages;
            synchronized (map) {
                tiles = this.cubemap.getFaceTiles(face, zoom).filter(p -> this.tileImages.get(p.a) != null).collect(Collectors.toMap(p -> (CubeMapTileXY)p.a, p -> this.tileImages.get(p.a)));
            }
            if (this.cubemap.getFaceTiles(face, zoom).count() != (long)tiles.size()) {
                return;
            }
            BufferedImage tImage = GraphicsUtils.buildMultiTiledCubemapFaceImage(tiles, zoom);
            BufferedImage finalImg = new BufferedImage(tImage.getWidth(), tImage.getHeight(), tImage.getType());
            Graphics2D g2d = finalImg.createGraphics();
            AffineTransform translate = AffineTransform.getScaleInstance(-1.0, 1.0);
            translate.concatenate(AffineTransform.getTranslateInstance(-finalImg.getWidth(), 0.0));
            g2d.drawImage(face == CubemapUtils.CubemapFaces.DOWN || face == CubemapUtils.CubemapFaces.UP ? GraphicsUtils.rotateImage(tImage) : tImage, new AffineTransformOp(translate, 2), 0, 0);
            g2d.dispose();
            finalImages[i] = SwingFXUtils.toFXImage((BufferedImage)finalImg, null);
        }
        for (i = 0; i < 6; ++i) {
            views[i].setImage(finalImages[i]);
        }
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().revalidate();
        StreetsideViewerDialog.getInstance().getStreetsideViewerPanel().repaint();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().setScene(StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().getCubemapScene());
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().revalidate();
        StreetsideViewerPanel.getThreeSixtyDegreeViewerPanel().repaint();
        long endTime = System.currentTimeMillis();
        long runTime = (endTime - this.startTime) / 1000L;
        String message = MessageFormat.format("Completed downloading, assembling and setting cubemap imagery for cubemap {0} in  {1} seconds.", this.cubemap.id(), runTime);
        if (Boolean.TRUE.equals(StreetsideProperties.DEBUGING_ENABLED.get())) {
            LOGGER.log(Logging.LEVEL_DEBUG, message);
        }
        this.resetTileImages();
        this.currentTileCount.set(0);
        this.isBuilding = false;
    }

    private void resetTileImages() {
        this.tileImages.clear();
    }

    public synchronized StreetsideAbstractImage getCubemap() {
        return this.cubemap;
    }
}

