/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside.actions;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.actions.WalkListener;
import org.openstreetmap.josm.plugins.streetside.actions.WalkThread;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideWalkDialog;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class StreetsideWalkAction
extends JosmAction
implements StreetsideDataListener {
    private static final long serialVersionUID = 3454223919402245818L;
    private final List<WalkListener> listeners = new ArrayList<WalkListener>();
    private WalkThread thread;

    public StreetsideWalkAction() {
        super(I18n.tr((String)"Walk mode", (Object[])new Object[0]), new ImageProvider(StreetsidePlugin.LOGO).setSize(ImageProvider.ImageSizes.DEFAULT).setOptional(true), I18n.tr((String)"Walk mode", (Object[])new Object[0]), null, false, "streetsideWalk", true);
    }

    public void actionPerformed(ActionEvent arg0) {
        StreetsideWalkDialog dialog = new StreetsideWalkDialog();
        JOptionPane pane = new JOptionPane(dialog, -1, 2);
        JDialog dlg = pane.createDialog((Component)MainApplication.getMainFrame(), I18n.tr((String)"Walk mode", (Object[])new Object[0]));
        dlg.setMinimumSize(new Dimension(400, 150));
        dlg.setVisible(true);
        if (pane.getValue() != null && (Integer)pane.getValue() == 0) {
            this.thread = new WalkThread((Integer)dialog.spin.getValue(), dialog.waitForPicture.isSelected(), dialog.followSelection.isSelected(), dialog.goForward.isSelected());
            this.fireWalkStarted();
            this.thread.start();
            StreetsideMainDialog.getInstance().setMode(StreetsideMainDialog.MODE.WALK);
        }
    }

    @Override
    public void imagesAdded() {
    }

    public void addListener(WalkListener lis) {
        this.listeners.add(lis);
    }

    public void removeListener(WalkListener lis) {
        this.listeners.remove(lis);
    }

    private void fireWalkStarted() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (WalkListener lis : this.listeners) {
            lis.walkStarted(this.thread);
        }
    }

    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    public void selectedImageChanged(StreetsideImage oldImage, StreetsideImage newImage) {
        if (oldImage == null && newImage != null) {
            this.setEnabled(true);
        } else if (oldImage != null && newImage == null) {
            this.setEnabled(false);
        }
    }

    protected void updateEnabledState() {
        super.updateEnabledState();
        this.setEnabled(StreetsideLayer.hasInstance() && StreetsideLayer.getInstance().getData().getSelectedImage() != null);
    }
}

