/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import jakarta.annotation.Nonnull;
import java.io.Serializable;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.openstreetmap.gui.jmapviewer.TileXY;
import org.openstreetmap.josm.data.IQuadBucketType;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.osm.BBox;
import org.openstreetmap.josm.plugins.streetside.CubeMapTileXY;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.cubemap.CubemapUtils;
import org.openstreetmap.josm.tools.Pair;

public sealed interface StreetsideAbstractImage
extends ILatLon,
IQuadBucketType,
Comparable<StreetsideAbstractImage>,
Serializable
permits StreetsideImage {
    public String id();

    public List<String> imageUrlSubdomains();

    public double heading();

    public int zoomMax();

    public int zoomMin();

    default public int xCols(int zoom) {
        return this.yCols(zoom);
    }

    default public int yCols(int zoom) {
        return 1 << zoom;
    }

    default public boolean visible() {
        return true;
    }

    default public BBox getBBox() {
        return new BBox((ILatLon)this);
    }

    default public String getThumbnail() {
        return this.getTile(Integer.toString(0), Integer.toString(1));
    }

    default public Stream<Pair<CubeMapTileXY, String>> getFaceTiles(CubemapUtils.CubemapFaces face, int zoom) {
        if (zoom > this.zoomMax() || zoom < this.zoomMin()) {
            throw new IndexOutOfBoundsException(zoom);
        }
        String faceId = face.faceId();
        String startingTileId = face.startingTileId();
        Stream<String> level = IntStream.range(0, 4).mapToObj(String::valueOf).map(startingTileId::concat);
        for (int currentZoom = this.zoomMin(); currentZoom < zoom; ++currentZoom) {
            level = level.flatMap(s -> IntStream.range(0, 4).mapToObj(String::valueOf).map(s::concat));
        }
        return level.map(s -> new Pair((Object)StreetsideAbstractImage.mapToTiles(face, zoom, s), (Object)this.getTile(faceId, (String)s)));
    }

    private static CubeMapTileXY mapToTiles(CubemapUtils.CubemapFaces face, int zoom, String tileId) {
        TileXY xy = StreetsideAbstractImage.quadKeyToTile(tileId.subSequence(tileId.length() - zoom, tileId.length()));
        return new CubeMapTileXY(face, xy.getXIndex(), xy.getYIndex());
    }

    @Nonnull
    public static TileXY quadKeyToTile(@Nonnull CharSequence quadkey) {
        int z = quadkey.length();
        int x = 0;
        int y = 0;
        block6: for (int i = z; i > 0; --i) {
            int mask = 1 << i - 1;
            switch (quadkey.charAt(z - i)) {
                case '0': {
                    continue block6;
                }
                case '1': {
                    x |= mask;
                    continue block6;
                }
                case '2': {
                    y |= mask;
                    continue block6;
                }
                case '3': {
                    x |= mask;
                    y |= mask;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Bad quadtile character at " + (i - 1) + " for '" + String.valueOf(quadkey) + "'");
                }
            }
        }
        return new TileXY((double)x, (double)y);
    }

    default public String getTile(String faceId, String tileId) {
        return this.id().replace("{subdomain}", this.imageUrlSubdomains().get(0)).replace("{faceId}", faceId).replace("{tileId}", tileId);
    }
}

